/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.datanode.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.exception.NotEnoughDataNodeException;
import org.apache.iotdb.confignode.exception.StorageGroupNotExistsException;
import org.apache.iotdb.confignode.manager.ClusterSchemaManager;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.NodeManager;
import org.apache.iotdb.confignode.manager.PartitionManager;
import org.apache.iotdb.confignode.manager.load.LoadManagerMetrics;
import org.apache.iotdb.confignode.manager.load.balancer.PartitionBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.RegionBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.RouteBalancer;
import org.apache.iotdb.confignode.manager.load.heartbeat.DataNodeHeartbeatCache;
import org.apache.iotdb.mpp.rpc.thrift.TRegionRouteReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadManager.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private final IManager configManager;
    private final RegionBalancer regionBalancer;
    private final PartitionBalancer partitionBalancer;
    private final RouteBalancer routeBalancer;
    private final LoadManagerMetrics loadManagerMetrics;
    private Future<?> currentLoadBalancingFuture;
    private final ScheduledExecutorService loadBalancingExecutor = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)LoadManager.class.getSimpleName());
    private final Object scheduleMonitor = new Object();

    public LoadManager(IManager configManager) {
        this.configManager = configManager;
        this.regionBalancer = new RegionBalancer(configManager);
        this.partitionBalancer = new PartitionBalancer(configManager);
        this.routeBalancer = new RouteBalancer(configManager);
        this.loadManagerMetrics = new LoadManagerMetrics(configManager);
    }

    public CreateRegionGroupsPlan allocateRegionGroups(Map<String, Integer> allotmentMap, TConsensusGroupType consensusGroupType) throws NotEnoughDataNodeException, StorageGroupNotExistsException {
        return this.regionBalancer.genRegionsAllocationPlan(allotmentMap, consensusGroupType);
    }

    public Map<String, SchemaPartitionTable> allocateSchemaPartition(Map<String, List<TSeriesPartitionSlot>> unassignedSchemaPartitionSlotsMap) {
        return this.partitionBalancer.allocateSchemaPartition(unassignedSchemaPartitionSlotsMap);
    }

    public Map<String, DataPartitionTable> allocateDataPartition(Map<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>> unassignedDataPartitionSlotsMap) {
        return this.partitionBalancer.allocateDataPartition(unassignedDataPartitionSlotsMap);
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> genLatestRegionRouteMap() {
        return this.routeBalancer.genLatestRegionRouteMap(this.getPartitionManager().getAllReplicaSets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLoadBalancingService() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentLoadBalancingFuture == null) {
                this.currentLoadBalancingFuture = ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.loadBalancingExecutor, this::updateNodeLoadStatistic, (long)0L, (long)NodeManager.HEARTBEAT_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
                LOGGER.info("LoadBalancing service is started successfully.");
            }
            this.loadManagerMetrics.addMetrics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLoadBalancingService() {
        this.loadManagerMetrics.removeMetrics();
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentLoadBalancingFuture != null) {
                this.currentLoadBalancingFuture.cancel(false);
                this.currentLoadBalancingFuture = null;
                LOGGER.info("LoadBalancing service is stopped successfully.");
            }
        }
    }

    private void updateNodeLoadStatistic() {
        AtomicBoolean existDataNodeChangesStatus = new AtomicBoolean(false);
        AtomicBoolean existSchemaRegionGroupChangesLeader = new AtomicBoolean(false);
        AtomicBoolean existDataRegionGroupChangesLeader = new AtomicBoolean(false);
        boolean isNeedBroadcast = false;
        this.getNodeManager().getNodeCacheMap().values().forEach(nodeCache -> {
            boolean updateResult = nodeCache.updateNodeStatus();
            if (nodeCache instanceof DataNodeHeartbeatCache) {
                existDataNodeChangesStatus.compareAndSet(false, updateResult);
            }
        });
        this.getPartitionManager().getRegionGroupCacheMap().values().forEach(regionGroupCache -> {
            boolean updateResult = regionGroupCache.updateLoadStatistic();
            switch (regionGroupCache.getConsensusGroupId().getType()) {
                case SchemaRegion: {
                    existSchemaRegionGroupChangesLeader.compareAndSet(false, updateResult);
                    break;
                }
                case DataRegion: {
                    existDataRegionGroupChangesLeader.compareAndSet(false, updateResult);
                }
            }
        });
        if (existDataNodeChangesStatus.get()) {
            isNeedBroadcast = true;
        }
        if ("leader".equals(CONF.getRoutingPolicy())) {
            if (existSchemaRegionGroupChangesLeader.get()) {
                isNeedBroadcast = true;
            }
            if (!"org.apache.iotdb.consensus.multileader.MultiLeaderConsensus".equals(CONF.getDataRegionConsensusProtocolClass()) && existDataRegionGroupChangesLeader.get()) {
                isNeedBroadcast = true;
            }
        }
        if (isNeedBroadcast) {
            this.broadcastLatestRegionRouteMap();
        }
    }

    public void broadcastLatestRegionRouteMap() {
        Map<TConsensusGroupId, TRegionReplicaSet> latestRegionRouteMap = this.genLatestRegionRouteMap();
        ConcurrentHashMap<Integer, TDataNodeLocation> dataNodeLocationMap = new ConcurrentHashMap<Integer, TDataNodeLocation>();
        this.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running).forEach(onlineDataNode -> dataNodeLocationMap.put(onlineDataNode.getLocation().getDataNodeId(), onlineDataNode.getLocation()));
        LOGGER.info("[latestRegionRouteMap] Begin to broadcast RegionRouteMap:");
        long broadcastTime = System.currentTimeMillis();
        LoadManager.printRegionRouteMap(broadcastTime, latestRegionRouteMap);
        AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNodeWithRetry(new TRegionRouteReq(broadcastTime, latestRegionRouteMap), dataNodeLocationMap, DataNodeRequestType.UPDATE_REGION_ROUTE_MAP, null);
        LOGGER.info("[latestRegionRouteMap] Broadcast the latest RegionRouteMap finished.");
    }

    public static void printRegionRouteMap(long timestamp, Map<TConsensusGroupId, TRegionReplicaSet> regionRouteMap) {
        LOGGER.info("[latestRegionRouteMap] timestamp:{}", (Object)timestamp);
        LOGGER.info("[latestRegionRouteMap] RegionRouteMap:");
        for (Map.Entry<TConsensusGroupId, TRegionReplicaSet> entry : regionRouteMap.entrySet()) {
            LOGGER.info("[latestRegionRouteMap]\t {}={}", (Object)entry.getKey(), entry.getValue().getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toList()));
        }
    }

    public RouteBalancer getRouteBalancer() {
        return this.routeBalancer;
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }
}

