/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.statemachine;

import java.io.File;
import java.io.IOException;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.exception.physical.UnknownPhysicalPlanTypeException;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.persistence.executor.ConfigPlanExecutor;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.request.ByteBufferConsensusRequest;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionRegionStateMachine
implements IStateMachine,
IStateMachine.EventApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionRegionStateMachine.class);
    private final ConfigPlanExecutor executor;
    private ConfigManager configManager;
    private final TEndPoint currentNode;

    public PartitionRegionStateMachine(ConfigManager configManager, ConfigPlanExecutor executor) {
        this.executor = executor;
        this.configManager = configManager;
        this.currentNode = new TEndPoint().setIp(ConfigNodeDescriptor.getInstance().getConf().getInternalAddress()).setPort(ConfigNodeDescriptor.getInstance().getConf().getConsensusPort());
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public TSStatus write(IConsensusRequest request) {
        ConfigPhysicalPlan plan;
        if (request instanceof ByteBufferConsensusRequest) {
            try {
                plan = ConfigPhysicalPlan.Factory.create(request.serializeToByteBuffer());
            }
            catch (IOException e) {
                LOGGER.error("Deserialization error for write plan : {}", (Object)request, (Object)e);
                return new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            }
        } else if (request instanceof ConfigPhysicalPlan) {
            plan = (ConfigPhysicalPlan)request;
        } else {
            LOGGER.error("Unexpected write plan : {}", (Object)request);
            return new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        return this.write(plan);
    }

    protected TSStatus write(ConfigPhysicalPlan plan) {
        TSStatus result;
        try {
            result = this.executor.executeNonQueryPlan(plan);
        }
        catch (AuthException | UnknownPhysicalPlanTypeException e) {
            LOGGER.error(e.getMessage());
            result = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        return result;
    }

    public DataSet read(IConsensusRequest request) {
        ConfigPhysicalPlan plan;
        if (request instanceof ByteBufferConsensusRequest) {
            try {
                plan = ConfigPhysicalPlan.Factory.create(request.serializeToByteBuffer());
            }
            catch (IOException e) {
                LOGGER.error("Deserialization error for write plan : {}", (Object)request);
                return null;
            }
        } else if (request instanceof ConfigPhysicalPlan) {
            plan = (ConfigPhysicalPlan)request;
        } else {
            LOGGER.error("Unexpected read plan : {}", (Object)request);
            return null;
        }
        return this.read(plan);
    }

    public boolean takeSnapshot(File snapshotDir) {
        return this.executor.takeSnapshot(snapshotDir);
    }

    public void loadSnapshot(File latestSnapshotRootDir) {
        this.executor.loadSnapshot(latestSnapshotRootDir);
    }

    protected DataSet read(ConfigPhysicalPlan plan) {
        DataSet result;
        try {
            result = this.executor.executeQueryPlan(plan);
        }
        catch (AuthException | UnknownPhysicalPlanTypeException e) {
            LOGGER.error(e.getMessage());
            result = null;
        }
        return result;
    }

    public void notifyLeaderChanged(ConsensusGroupId groupId, TEndPoint newLeader) {
        if (this.currentNode.equals(newLeader)) {
            LOGGER.info("Current node {} becomes Leader", (Object)newLeader);
            this.configManager.getProcedureManager().shiftExecutor(true);
            this.configManager.getLoadManager().startLoadBalancingService();
            this.configManager.getNodeManager().startHeartbeatService();
            this.configManager.getPartitionManager().startRegionCleaner();
        } else {
            LOGGER.info("Current node {} is not longer the leader, the new leader is {}", (Object)this.currentNode, (Object)newLeader);
            this.configManager.getProcedureManager().shiftExecutor(false);
            this.configManager.getLoadManager().stopLoadBalancingService();
            this.configManager.getNodeManager().stopHeartbeatService();
            this.configManager.getPartitionManager().stopRegionCleaner();
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isReadOnly() {
        return CommonDescriptor.getInstance().getConfig().isReadOnly();
    }
}

