/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.utils.BasicStructureSerDeUtil;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.CreateRegionGroupsPlan;

public class DeleteRegionGroupsPlan
extends CreateRegionGroupsPlan {
    boolean needsDeleteInPartitionTable = true;

    public DeleteRegionGroupsPlan() {
        super(ConfigPhysicalPlanType.DeleteRegionGroups);
    }

    public boolean isNeedsDeleteInPartitionTable() {
        return this.needsDeleteInPartitionTable;
    }

    public void setNeedsDeleteInPartitionTable(boolean needsDeleteInPartitionTable) {
        this.needsDeleteInPartitionTable = needsDeleteInPartitionTable;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeInt(ConfigPhysicalPlanType.DeleteRegionGroups.ordinal());
        stream.writeByte(this.needsDeleteInPartitionTable ? 1 : 0);
        stream.writeInt(this.regionGroupMap.size());
        for (Map.Entry entry : this.regionGroupMap.entrySet()) {
            BasicStructureSerDeUtil.write((String)((String)entry.getKey()), (DataOutputStream)stream);
            stream.writeInt(((List)entry.getValue()).size());
            for (TRegionReplicaSet regionReplicaSet : (List)entry.getValue()) {
                ThriftCommonsSerDeUtils.serializeTRegionReplicaSet((TRegionReplicaSet)regionReplicaSet, (DataOutputStream)stream);
            }
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.needsDeleteInPartitionTable = buffer.get() > 0;
        int length = buffer.getInt();
        for (int i = 0; i < length; ++i) {
            String name = BasicStructureSerDeUtil.readString((ByteBuffer)buffer);
            this.regionGroupMap.put(name, new ArrayList());
            int regionNum = buffer.getInt();
            for (int j = 0; j < regionNum; ++j) {
                ((List)this.regionGroupMap.get(name)).add(ThriftCommonsSerDeUtils.deserializeTRegionReplicaSet((ByteBuffer)buffer));
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteRegionGroupsPlan that = (DeleteRegionGroupsPlan)o;
        return this.regionGroupMap.equals(that.regionGroupMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.regionGroupMap);
    }
}

