/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.conf;

import java.io.File;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.confignode.manager.load.balancer.RegionBalancer;

public class ConfigNodeConfig {
    private String internalAddress = "0.0.0.0";
    private int internalPort = 22277;
    private int consensusPort = 22278;
    private TEndPoint targetConfigNode = new TEndPoint("0.0.0.0", 22277);
    private int partitionRegionId = 0;
    private String configNodeConsensusProtocolClass = "org.apache.iotdb.consensus.ratis.RatisConsensus";
    private String schemaRegionConsensusProtocolClass = "org.apache.iotdb.consensus.standalone.StandAloneConsensus";
    private double schemaRegionPerDataNode = 1.0;
    private String dataRegionConsensusProtocolClass = "org.apache.iotdb.consensus.standalone.StandAloneConsensus";
    private double dataRegionPerProcessor = 0.5;
    private RegionBalancer.RegionAllocateStrategy regionAllocateStrategy = RegionBalancer.RegionAllocateStrategy.GREEDY;
    private int seriesPartitionSlotNum = 10000;
    private String seriesPartitionExecutorClass = "org.apache.iotdb.commons.partition.executor.hash.BKDRHashExecutor";
    private int rpcMaxConcurrentClientNum = 65535;
    private boolean rpcAdvancedCompressionEnable = false;
    private int thriftMaxFrameSize = 0x20000000;
    private int thriftDefaultBufferSize = 1024;
    private int thriftServerAwaitTimeForStopService = 60;
    private String systemDir = "data" + File.separator + "system";
    private String consensusDir = "data" + File.separator + "consensus";
    private String extLibDir = "ext";
    private String udfLibDir = "ext" + File.separator + "udf";
    private String temporaryLibDir = "ext" + File.separator + "temporary";
    private long timePartitionInterval = 86400L;
    private int schemaReplicationFactor = 1;
    private int dataReplicationFactor = 1;
    private int procedureCompletedEvictTTL = 800;
    private int procedureCompletedCleanInterval = 30;
    private int procedureCoreWorkerThreadsSize = Math.max(Runtime.getRuntime().availableProcessors() / 4, 16);
    private long heartbeatInterval = 1000L;
    private String routingPolicy = "leader";
    private String readConsistencyLevel = "strong";

    public void updatePath() {
        this.formulateFolders();
    }

    private void formulateFolders() {
        this.systemDir = this.addHomeDir(this.systemDir);
        this.consensusDir = this.addHomeDir(this.consensusDir);
        this.extLibDir = this.addHomeDir(this.extLibDir);
        this.udfLibDir = this.addHomeDir(this.udfLibDir);
        this.temporaryLibDir = this.addHomeDir(this.temporaryLibDir);
    }

    private String addHomeDir(String dir) {
        String homeDir = System.getProperty("CONFIGNODE_HOME", null);
        if (!new File(dir).isAbsolute() && homeDir != null && homeDir.length() > 0) {
            dir = !homeDir.endsWith(File.separator) ? homeDir + File.separatorChar + dir : homeDir + dir;
        }
        return dir;
    }

    public String getInternalAddress() {
        return this.internalAddress;
    }

    public void setInternalAddress(String internalAddress) {
        this.internalAddress = internalAddress;
    }

    public int getInternalPort() {
        return this.internalPort;
    }

    public void setInternalPort(int internalPort) {
        this.internalPort = internalPort;
    }

    public int getConsensusPort() {
        return this.consensusPort;
    }

    public void setConsensusPort(int consensusPort) {
        this.consensusPort = consensusPort;
    }

    public TEndPoint getTargetConfigNode() {
        return this.targetConfigNode;
    }

    public void setTargetConfigNode(TEndPoint targetConfigNode) {
        this.targetConfigNode = targetConfigNode;
    }

    public int getPartitionRegionId() {
        return this.partitionRegionId;
    }

    public void setPartitionRegionId(int partitionRegionId) {
        this.partitionRegionId = partitionRegionId;
    }

    public int getSeriesPartitionSlotNum() {
        return this.seriesPartitionSlotNum;
    }

    public void setSeriesPartitionSlotNum(int seriesPartitionSlotNum) {
        this.seriesPartitionSlotNum = seriesPartitionSlotNum;
    }

    public String getSeriesPartitionExecutorClass() {
        return this.seriesPartitionExecutorClass;
    }

    public void setSeriesPartitionExecutorClass(String seriesPartitionExecutorClass) {
        this.seriesPartitionExecutorClass = seriesPartitionExecutorClass;
    }

    public long getTimePartitionInterval() {
        return this.timePartitionInterval;
    }

    public void setTimePartitionInterval(long timePartitionInterval) {
        this.timePartitionInterval = timePartitionInterval;
    }

    public int getRpcMaxConcurrentClientNum() {
        return this.rpcMaxConcurrentClientNum;
    }

    public void setRpcMaxConcurrentClientNum(int rpcMaxConcurrentClientNum) {
        this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
    }

    public boolean isRpcAdvancedCompressionEnable() {
        return this.rpcAdvancedCompressionEnable;
    }

    public void setRpcAdvancedCompressionEnable(boolean rpcAdvancedCompressionEnable) {
        this.rpcAdvancedCompressionEnable = rpcAdvancedCompressionEnable;
    }

    public int getThriftMaxFrameSize() {
        return this.thriftMaxFrameSize;
    }

    public void setThriftMaxFrameSize(int thriftMaxFrameSize) {
        this.thriftMaxFrameSize = thriftMaxFrameSize;
    }

    public int getThriftDefaultBufferSize() {
        return this.thriftDefaultBufferSize;
    }

    public void setThriftDefaultBufferSize(int thriftDefaultBufferSize) {
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
    }

    public String getConsensusDir() {
        return this.consensusDir;
    }

    public void setConsensusDir(String consensusDir) {
        this.consensusDir = consensusDir;
    }

    public String getConfigNodeConsensusProtocolClass() {
        return this.configNodeConsensusProtocolClass;
    }

    public void setConfigNodeConsensusProtocolClass(String configNodeConsensusProtocolClass) {
        this.configNodeConsensusProtocolClass = configNodeConsensusProtocolClass;
    }

    public String getSchemaRegionConsensusProtocolClass() {
        return this.schemaRegionConsensusProtocolClass;
    }

    public void setSchemaRegionConsensusProtocolClass(String schemaRegionConsensusProtocolClass) {
        this.schemaRegionConsensusProtocolClass = schemaRegionConsensusProtocolClass;
    }

    public double getSchemaRegionPerDataNode() {
        return this.schemaRegionPerDataNode;
    }

    public void setSchemaRegionPerDataNode(double schemaRegionPerDataNode) {
        this.schemaRegionPerDataNode = schemaRegionPerDataNode;
    }

    public String getDataRegionConsensusProtocolClass() {
        return this.dataRegionConsensusProtocolClass;
    }

    public void setDataRegionConsensusProtocolClass(String dataRegionConsensusProtocolClass) {
        this.dataRegionConsensusProtocolClass = dataRegionConsensusProtocolClass;
    }

    public double getDataRegionPerProcessor() {
        return this.dataRegionPerProcessor;
    }

    public void setDataRegionPerProcessor(double dataRegionPerProcessor) {
        this.dataRegionPerProcessor = dataRegionPerProcessor;
    }

    public RegionBalancer.RegionAllocateStrategy getRegionAllocateStrategy() {
        return this.regionAllocateStrategy;
    }

    public void setRegionAllocateStrategy(RegionBalancer.RegionAllocateStrategy regionAllocateStrategy) {
        this.regionAllocateStrategy = regionAllocateStrategy;
    }

    public int getThriftServerAwaitTimeForStopService() {
        return this.thriftServerAwaitTimeForStopService;
    }

    public void setThriftServerAwaitTimeForStopService(int thriftServerAwaitTimeForStopService) {
        this.thriftServerAwaitTimeForStopService = thriftServerAwaitTimeForStopService;
    }

    public String getSystemDir() {
        return this.systemDir;
    }

    public void setSystemDir(String systemDir) {
        this.systemDir = systemDir;
    }

    public String getSystemUdfDir() {
        return this.getSystemDir() + File.separator + "udf" + File.separator;
    }

    public String getUdfLibDir() {
        return this.udfLibDir;
    }

    public void setUdfLibDir(String udfLibDir) {
        this.udfLibDir = udfLibDir;
    }

    public String getTemporaryLibDir() {
        return this.temporaryLibDir;
    }

    public void setTemporaryLibDir(String temporaryLibDir) {
        this.temporaryLibDir = temporaryLibDir;
    }

    public int getSchemaReplicationFactor() {
        return this.schemaReplicationFactor;
    }

    public void setSchemaReplicationFactor(int schemaReplicationFactor) {
        this.schemaReplicationFactor = schemaReplicationFactor;
    }

    public int getDataReplicationFactor() {
        return this.dataReplicationFactor;
    }

    public void setDataReplicationFactor(int dataReplicationFactor) {
        this.dataReplicationFactor = dataReplicationFactor;
    }

    public int getProcedureCompletedEvictTTL() {
        return this.procedureCompletedEvictTTL;
    }

    public void setProcedureCompletedEvictTTL(int procedureCompletedEvictTTL) {
        this.procedureCompletedEvictTTL = procedureCompletedEvictTTL;
    }

    public int getProcedureCompletedCleanInterval() {
        return this.procedureCompletedCleanInterval;
    }

    public void setProcedureCompletedCleanInterval(int procedureCompletedCleanInterval) {
        this.procedureCompletedCleanInterval = procedureCompletedCleanInterval;
    }

    public int getProcedureCoreWorkerThreadsSize() {
        return this.procedureCoreWorkerThreadsSize;
    }

    public void setProcedureCoreWorkerThreadsSize(int procedureCoreWorkerThreadsSize) {
        this.procedureCoreWorkerThreadsSize = procedureCoreWorkerThreadsSize;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(long heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public String getRoutingPolicy() {
        return this.routingPolicy;
    }

    public void setRoutingPolicy(String routingPolicy) {
        this.routingPolicy = routingPolicy;
    }

    public String getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public void setReadConsistencyLevel(String readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel;
    }
}

