/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.handlers.AbstractRetryHandler;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetTTLHandler
extends AbstractRetryHandler
implements AsyncMethodCallback<TSStatus> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetTTLHandler.class);

    public SetTTLHandler(CountDownLatch countDownLatch, DataNodeRequestType requestType, TDataNodeLocation targetDataNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap) {
        super(countDownLatch, requestType, targetDataNode, dataNodeLocationMap);
    }

    public void onComplete(TSStatus response) {
        if (response.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.dataNodeLocationMap.remove(this.targetDataNode.getDataNodeId());
            LOGGER.info("Successfully SetTTL on DataNode: {}", (Object)this.targetDataNode);
        } else {
            LOGGER.error("Failed to SetTTL on DataNode: {}, {}", (Object)this.targetDataNode, (Object)response);
        }
        this.countDownLatch.countDown();
    }

    public void onError(Exception e) {
        this.countDownLatch.countDown();
        LOGGER.error("Failed to SetTTL on DataNode: {}", (Object)this.targetDataNode);
    }
}

