/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.datanode;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.handlers.AbstractRetryHandler;
import org.apache.iotdb.confignode.client.async.handlers.ClearCacheHandler;
import org.apache.iotdb.confignode.client.async.handlers.CreateRegionHandler;
import org.apache.iotdb.confignode.client.async.handlers.FlushHandler;
import org.apache.iotdb.confignode.client.async.handlers.FunctionManagementHandler;
import org.apache.iotdb.confignode.client.async.handlers.LoadConfigurationHandler;
import org.apache.iotdb.confignode.client.async.handlers.MergeHandler;
import org.apache.iotdb.confignode.client.async.handlers.SetSystemStatusHandler;
import org.apache.iotdb.confignode.client.async.handlers.SetTTLHandler;
import org.apache.iotdb.confignode.client.async.handlers.UpdateConfigNodeGroupHandler;
import org.apache.iotdb.confignode.client.async.handlers.UpdateRegionRouteMapHandler;
import org.apache.iotdb.confignode.consensus.request.write.CreateRegionGroupsPlan;
import org.apache.iotdb.mpp.rpc.thrift.TCreateDataRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TCreateFunctionRequest;
import org.apache.iotdb.mpp.rpc.thrift.TCreateSchemaRegionReq;
import org.apache.iotdb.mpp.rpc.thrift.TDropFunctionRequest;
import org.apache.iotdb.mpp.rpc.thrift.TRegionRouteReq;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateConfigNodeGroupReq;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncDataNodeClientPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncDataNodeClientPool.class);
    private final IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> clientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new ClientPoolFactory.AsyncDataNodeInternalServiceClientPoolFactory());
    private static final int MAX_RETRY_NUM = 6;

    private AsyncDataNodeClientPool() {
    }

    public void sendAsyncRequestToDataNodeWithRetry(Object req, Map<Integer, TDataNodeLocation> dataNodeLocationMap, DataNodeRequestType requestType, List<TSStatus> dataNodeResponseStatus) {
        if (dataNodeLocationMap.isEmpty()) {
            return;
        }
        for (int retry = 0; retry < 6; ++retry) {
            CountDownLatch countDownLatch = new CountDownLatch(dataNodeLocationMap.size());
            for (TDataNodeLocation targetDataNode : dataNodeLocationMap.values()) {
                AbstractRetryHandler handler;
                switch (requestType) {
                    case SET_TTL: {
                        handler = new SetTTLHandler(countDownLatch, requestType, targetDataNode, dataNodeLocationMap);
                        break;
                    }
                    case CREATE_FUNCTION: 
                    case DROP_FUNCTION: {
                        handler = new FunctionManagementHandler(countDownLatch, requestType, targetDataNode, dataNodeLocationMap, dataNodeResponseStatus);
                        break;
                    }
                    case FULL_MERGE: 
                    case MERGE: {
                        handler = new MergeHandler(countDownLatch, requestType, targetDataNode, dataNodeLocationMap, dataNodeResponseStatus);
                        break;
                    }
                    case FLUSH: {
                        handler = new FlushHandler(countDownLatch, requestType, targetDataNode, dataNodeLocationMap, dataNodeResponseStatus);
                        break;
                    }
                    case CLEAR_CACHE: {
                        handler = new ClearCacheHandler(countDownLatch, requestType, targetDataNode, dataNodeLocationMap, dataNodeResponseStatus);
                        break;
                    }
                    case LOAD_CONFIGURATION: {
                        handler = new LoadConfigurationHandler(countDownLatch, requestType, targetDataNode, dataNodeLocationMap, dataNodeResponseStatus);
                        break;
                    }
                    case SET_SYSTEM_STATUS: {
                        handler = new SetSystemStatusHandler(countDownLatch, requestType, targetDataNode, dataNodeLocationMap, dataNodeResponseStatus);
                        break;
                    }
                    case UPDATE_REGION_ROUTE_MAP: {
                        handler = new UpdateRegionRouteMapHandler(countDownLatch, requestType, targetDataNode, dataNodeLocationMap);
                        break;
                    }
                    case BROADCAST_LATEST_CONFIG_NODE_GROUP: {
                        handler = new UpdateConfigNodeGroupHandler(countDownLatch, requestType, targetDataNode, dataNodeLocationMap);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.sendAsyncRequestToDataNode(targetDataNode, req, handler, retry);
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted during {} on ConfigNode", (Object)requestType);
            }
            if (dataNodeLocationMap.isEmpty()) break;
        }
    }

    public void sendAsyncRequestToDataNode(TDataNodeLocation dataNodeLocation, Object req, AbstractRetryHandler handler, int retryCount) {
        try {
            AsyncDataNodeInternalServiceClient client = (AsyncDataNodeInternalServiceClient)this.clientManager.borrowClient((Object)dataNodeLocation.getInternalEndPoint());
            switch (handler.getDataNodeRequestType()) {
                case SET_TTL: {
                    client.setTTL((TSetTTLReq)req, (AsyncMethodCallback)((SetTTLHandler)handler));
                    break;
                }
                case CREATE_DATA_REGIONS: {
                    client.createDataRegion((TCreateDataRegionReq)req, (AsyncMethodCallback)((CreateRegionHandler)handler));
                    break;
                }
                case CREATE_SCHEMA_REGIONS: {
                    client.createSchemaRegion((TCreateSchemaRegionReq)req, (AsyncMethodCallback)((CreateRegionHandler)handler));
                    break;
                }
                case CREATE_FUNCTION: {
                    client.createFunction((TCreateFunctionRequest)req, (AsyncMethodCallback)((FunctionManagementHandler)handler));
                    break;
                }
                case DROP_FUNCTION: {
                    client.dropFunction((TDropFunctionRequest)req, (AsyncMethodCallback)((FunctionManagementHandler)handler));
                    break;
                }
                case FULL_MERGE: 
                case MERGE: {
                    client.merge((AsyncMethodCallback)((MergeHandler)handler));
                    break;
                }
                case FLUSH: {
                    client.flush((TFlushReq)req, (AsyncMethodCallback)((FlushHandler)handler));
                    break;
                }
                case CLEAR_CACHE: {
                    client.clearCache((AsyncMethodCallback)((ClearCacheHandler)handler));
                    break;
                }
                case LOAD_CONFIGURATION: {
                    client.loadConfiguration((AsyncMethodCallback)((LoadConfigurationHandler)handler));
                    break;
                }
                case SET_SYSTEM_STATUS: {
                    client.setSystemStatus((String)req, (AsyncMethodCallback)((SetSystemStatusHandler)handler));
                    break;
                }
                case UPDATE_REGION_ROUTE_MAP: {
                    client.updateRegionCache((TRegionRouteReq)req, (AsyncMethodCallback)((UpdateRegionRouteMapHandler)handler));
                    break;
                }
                case BROADCAST_LATEST_CONFIG_NODE_GROUP: {
                    client.updateConfigNodeGroup((TUpdateConfigNodeGroupReq)req, (AsyncMethodCallback)((UpdateConfigNodeGroupHandler)handler));
                    break;
                }
                default: {
                    LOGGER.error("Unexpected DataNode Request Type: {} when sendAsyncRequestToDataNode", (Object)handler.getDataNodeRequestType());
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("{} failed on ConfigNode {}, because {}, retrying {}...", new Object[]{handler.getDataNodeRequestType(), dataNodeLocation.getInternalEndPoint(), e.getMessage(), retryCount});
        }
    }

    public Map<TConsensusGroupId, TRegionReplicaSet> createRegionGroups(CreateRegionGroupsPlan createRegionGroupsPlan, Map<String, Long> ttlMap) {
        ConcurrentHashMap<Integer, TDataNodeLocation> dataNodeLocationMap = new ConcurrentHashMap<Integer, TDataNodeLocation>();
        int index = 0;
        for (List<TRegionReplicaSet> regionReplicaSets : createRegionGroupsPlan.getRegionGroupMap().values()) {
            for (TRegionReplicaSet tRegionReplicaSet : regionReplicaSets) {
                for (TDataNodeLocation dataNodeLocation : tRegionReplicaSet.getDataNodeLocations()) {
                    dataNodeLocationMap.put(index++, dataNodeLocation);
                }
            }
        }
        if (dataNodeLocationMap.isEmpty()) {
            return new HashMap<TConsensusGroupId, TRegionReplicaSet>();
        }
        for (int retry = 0; retry < 6; ++retry) {
            index = 0;
            CountDownLatch countDownLatch = new CountDownLatch(dataNodeLocationMap.size());
            for (Map.Entry entry : createRegionGroupsPlan.getRegionGroupMap().entrySet()) {
                for (TRegionReplicaSet regionReplicaSet : (List)entry.getValue()) {
                    block12: for (TDataNodeLocation targetDataNode : regionReplicaSet.getDataNodeLocations()) {
                        if (dataNodeLocationMap.containsKey(index)) {
                            switch (regionReplicaSet.getRegionId().getType()) {
                                case SchemaRegion: {
                                    CreateRegionHandler handler = new CreateRegionHandler(countDownLatch, DataNodeRequestType.CREATE_SCHEMA_REGIONS, regionReplicaSet.regionId, targetDataNode, dataNodeLocationMap, index++);
                                    this.sendAsyncRequestToDataNode(targetDataNode, this.genCreateSchemaRegionReq((String)entry.getKey(), regionReplicaSet), handler, retry);
                                    continue block12;
                                }
                                case DataRegion: {
                                    CreateRegionHandler handler = new CreateRegionHandler(countDownLatch, DataNodeRequestType.CREATE_DATA_REGIONS, regionReplicaSet.regionId, targetDataNode, dataNodeLocationMap, index++);
                                    this.sendAsyncRequestToDataNode(targetDataNode, this.genCreateDataRegionReq((String)entry.getKey(), regionReplicaSet, ttlMap.get(entry.getKey())), handler, retry);
                                    continue block12;
                                }
                            }
                            continue;
                        }
                        ++index;
                    }
                }
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted during createRegions on ConfigNode");
            }
            if (dataNodeLocationMap.isEmpty()) break;
        }
        index = 0;
        HashMap<TConsensusGroupId, TRegionReplicaSet> failedRegions = new HashMap<TConsensusGroupId, TRegionReplicaSet>();
        for (List<TRegionReplicaSet> regionReplicaSets : createRegionGroupsPlan.getRegionGroupMap().values()) {
            for (TRegionReplicaSet regionReplicaSet : regionReplicaSets) {
                for (TDataNodeLocation dataNodeLocation : regionReplicaSet.getDataNodeLocations()) {
                    if (dataNodeLocationMap.containsKey(index)) {
                        failedRegions.computeIfAbsent(regionReplicaSet.getRegionId(), empty -> new TRegionReplicaSet().setRegionId(regionReplicaSet.getRegionId())).addToDataNodeLocations(dataNodeLocation);
                    }
                    ++index;
                }
            }
        }
        return failedRegions;
    }

    private TCreateSchemaRegionReq genCreateSchemaRegionReq(String storageGroup, TRegionReplicaSet regionReplicaSet) {
        TCreateSchemaRegionReq req = new TCreateSchemaRegionReq();
        req.setStorageGroup(storageGroup);
        req.setRegionReplicaSet(regionReplicaSet);
        return req;
    }

    private TCreateDataRegionReq genCreateDataRegionReq(String storageGroup, TRegionReplicaSet regionReplicaSet, long TTL) {
        TCreateDataRegionReq req = new TCreateDataRegionReq();
        req.setStorageGroup(storageGroup);
        req.setRegionReplicaSet(regionReplicaSet);
        req.setTtl(TTL);
        return req;
    }

    public void broadCastTheLatestConfigNodeGroup(Map<Integer, TDataNodeLocation> registeredDataNodeLocationMap, List<TConfigNodeLocation> registeredConfigNodes) {
        if (registeredDataNodeLocationMap != null) {
            TUpdateConfigNodeGroupReq updateConfigNodeGroupReq = new TUpdateConfigNodeGroupReq(registeredConfigNodes);
            LOGGER.info("Begin to broadcast the latest configNodeGroup: {}", registeredConfigNodes);
            this.sendAsyncRequestToDataNodeWithRetry(updateConfigNodeGroupReq, registeredDataNodeLocationMap, DataNodeRequestType.BROADCAST_LATEST_CONFIG_NODE_GROUP, null);
            LOGGER.info("Broadcast the latest configNodeGroup finished.");
        }
    }

    public void resetClient(TEndPoint endPoint) {
        this.clientManager.clear((Object)endPoint);
    }

    public static AsyncDataNodeClientPool getInstance() {
        return ClientPoolHolder.INSTANCE;
    }

    private static class ClientPoolHolder {
        private static final AsyncDataNodeClientPool INSTANCE = new AsyncDataNodeClientPool();

        private ClientPoolHolder() {
        }
    }
}

