/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.TimeseriesSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUtils {
    private static final Map<TSDataType, Set<TSEncoding>> schemaChecker = new EnumMap<TSDataType, Set<TSEncoding>>(TSDataType.class);
    private static final Logger logger;

    private SchemaUtils() {
    }

    public static void registerTimeseries(TimeseriesSchema schema) {
        block3: {
            try {
                logger.debug("Registering timeseries {}", (Object)schema);
                PartialPath path = new PartialPath(schema.getFullPath());
                TSDataType dataType = schema.getType();
                TSEncoding encoding = schema.getEncodingType();
                CompressionType compressionType = schema.getCompressor();
                IoTDB.schemaProcessor.createTimeseries(path, dataType, encoding, compressionType, Collections.emptyMap());
            }
            catch (PathAlreadyExistException path) {
            }
            catch (MetadataException e) {
                if (e.getCause() instanceof ClosedByInterruptException || e.getCause() instanceof ClosedChannelException) break block3;
                logger.error("Cannot create timeseries {} in snapshot, ignored", (Object)schema.getFullPath(), (Object)e);
            }
        }
    }

    public static void cacheTimeseriesSchema(TimeseriesSchema schema) {
        PartialPath path;
        try {
            path = new PartialPath(schema.getFullPath());
        }
        catch (IllegalPathException e) {
            logger.error("Cannot cache an illegal path {}", (Object)schema.getFullPath());
            return;
        }
        TSDataType dataType = schema.getType();
        TSEncoding encoding = schema.getEncodingType();
        CompressionType compressionType = schema.getCompressor();
        MeasurementSchema measurementSchema = new MeasurementSchema(path.getMeasurement(), dataType, encoding, compressionType);
        IMeasurementMNode measurementMNode = MeasurementMNode.getMeasurementMNode(null, path.getMeasurement(), (IMeasurementSchema)measurementSchema, null);
        IoTDB.schemaProcessor.cacheMeta(path, measurementMNode, true);
    }

    public static List<TSDataType> getSeriesTypesByPaths(Collection<? extends PartialPath> paths) {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (PartialPath partialPath : paths) {
            dataTypes.add(partialPath == null ? null : partialPath.getSeriesType());
        }
        return dataTypes;
    }

    public static List<TSDataType> getAggregatedDataTypes(List<TSDataType> measurementDataType, String aggregation) {
        TSDataType dataType = SchemaUtils.getAggregationType(aggregation);
        if (dataType != null) {
            return Collections.nCopies(measurementDataType.size(), dataType);
        }
        return measurementDataType;
    }

    public static List<TSDataType> getSeriesTypesByPaths(List<MeasurementPath> paths, List<String> aggregations) {
        ArrayList<TSDataType> tsDataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < paths.size(); ++i) {
            String aggrStr = aggregations != null ? aggregations.get(i) : null;
            TSDataType dataType = SchemaUtils.getAggregationType(aggrStr);
            if (dataType != null) {
                tsDataTypes.add(dataType);
                continue;
            }
            PartialPath path = paths.get(i);
            tsDataTypes.add(path == null ? null : path.getSeriesType());
        }
        return tsDataTypes;
    }

    public static TSDataType getSeriesTypeByPath(PartialPath path, String aggregation) {
        TSDataType dataType = SchemaUtils.getAggregationType(aggregation);
        if (dataType != null) {
            return dataType;
        }
        return path.getSeriesType();
    }

    public static TSDataType getAggregationType(String aggregation) {
        if (aggregation == null) {
            return null;
        }
        switch (aggregation.toLowerCase()) {
            case "min_time": 
            case "max_time": 
            case "count": {
                return TSDataType.INT64;
            }
            case "avg": 
            case "sum": {
                return TSDataType.DOUBLE;
            }
        }
        return null;
    }

    public static boolean isConsistentWithScanOrder(AggregationType aggregationFunction, Ordering scanOrder) {
        boolean ascending = scanOrder == Ordering.ASC;
        switch (aggregationFunction) {
            case MIN_TIME: 
            case FIRST_VALUE: {
                return ascending;
            }
            case MAX_TIME: 
            case LAST_VALUE: {
                return !ascending;
            }
            case SUM: 
            case MIN_VALUE: 
            case MAX_VALUE: 
            case EXTREME: 
            case COUNT: 
            case AVG: {
                return true;
            }
        }
        throw new IllegalArgumentException(String.format("Invalid Aggregation function: %s", new Object[]{aggregationFunction}));
    }

    public static Throwable findMetaMissingException(Throwable currEx) {
        while (true) {
            if (currEx instanceof PathNotExistException || currEx instanceof StorageGroupNotSetException) {
                return currEx;
            }
            if (currEx.getCause() == null) break;
            currEx = currEx.getCause();
        }
        return null;
    }

    public static void checkDataTypeWithEncoding(TSDataType dataType, TSEncoding encoding) throws MetadataException {
        if (!schemaChecker.get(dataType).contains(encoding)) {
            throw new MetadataException(String.format("encoding %s does not support %s", encoding, dataType), true);
        }
    }

    public static List<AggregationType> splitPartialAggregation(AggregationType aggregationType) {
        switch (aggregationType) {
            case FIRST_VALUE: {
                return Collections.singletonList(AggregationType.MIN_TIME);
            }
            case LAST_VALUE: {
                return Collections.singletonList(AggregationType.MAX_TIME);
            }
            case AVG: {
                return Arrays.asList(AggregationType.COUNT, AggregationType.SUM);
            }
            case MIN_TIME: 
            case MAX_TIME: 
            case SUM: 
            case MIN_VALUE: 
            case MAX_VALUE: 
            case EXTREME: 
            case COUNT: {
                return Collections.emptyList();
            }
        }
        throw new IllegalArgumentException(String.format("Invalid Aggregation function: %s", new Object[]{aggregationType}));
    }

    static {
        HashSet<TSEncoding> booleanSet = new HashSet<TSEncoding>();
        booleanSet.add(TSEncoding.PLAIN);
        booleanSet.add(TSEncoding.RLE);
        schemaChecker.put(TSDataType.BOOLEAN, booleanSet);
        HashSet<TSEncoding> intSet = new HashSet<TSEncoding>();
        intSet.add(TSEncoding.PLAIN);
        intSet.add(TSEncoding.RLE);
        intSet.add(TSEncoding.TS_2DIFF);
        intSet.add(TSEncoding.GORILLA);
        intSet.add(TSEncoding.ZIGZAG);
        intSet.add(TSEncoding.FREQ);
        schemaChecker.put(TSDataType.INT32, intSet);
        schemaChecker.put(TSDataType.INT64, intSet);
        HashSet<TSEncoding> floatSet = new HashSet<TSEncoding>();
        floatSet.add(TSEncoding.PLAIN);
        floatSet.add(TSEncoding.RLE);
        floatSet.add(TSEncoding.TS_2DIFF);
        floatSet.add(TSEncoding.GORILLA_V1);
        floatSet.add(TSEncoding.GORILLA);
        floatSet.add(TSEncoding.FREQ);
        schemaChecker.put(TSDataType.FLOAT, floatSet);
        schemaChecker.put(TSDataType.DOUBLE, floatSet);
        HashSet<TSEncoding> textSet = new HashSet<TSEncoding>();
        textSet.add(TSEncoding.PLAIN);
        textSet.add(TSEncoding.DICTIONARY);
        schemaChecker.put(TSDataType.TEXT, textSet);
        logger = LoggerFactory.getLogger(SchemaUtils.class);
    }
}

