/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.pipe;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.sync.SyncPathUtil;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.exception.sync.PipeException;
import org.apache.iotdb.db.sync.pipedata.DeletionPipeData;
import org.apache.iotdb.db.sync.pipedata.PipeData;
import org.apache.iotdb.db.sync.pipedata.TsFilePipeData;
import org.apache.iotdb.db.sync.pipedata.queue.BufferedPipeDataQueue;
import org.apache.iotdb.db.sync.sender.manager.ISyncManager;
import org.apache.iotdb.db.sync.sender.manager.LocalSyncManager;
import org.apache.iotdb.db.sync.sender.pipe.Pipe;
import org.apache.iotdb.db.sync.sender.pipe.PipeSink;
import org.apache.iotdb.db.sync.sender.recovery.TsFilePipeLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFilePipe
implements Pipe {
    private static final Logger logger = LoggerFactory.getLogger(TsFilePipe.class);
    private final Map<String, ISyncManager> syncManagerMap = new ConcurrentHashMap<String, ISyncManager>();
    private final long createTime;
    private final String name;
    private final PipeSink pipeSink;
    private final long dataStartTime;
    private final boolean syncDelOp;
    private final BufferedPipeDataQueue historyQueue;
    private final BufferedPipeDataQueue realTimeQueue;
    private final TsFilePipeLogger pipeLog;
    private final ReentrantLock collectRealTimeDataLock;
    private long maxSerialNumber;
    private Pipe.PipeStatus status;

    public TsFilePipe(long createTime, String name, PipeSink pipeSink, long dataStartTime, boolean syncDelOp) {
        this.createTime = createTime;
        this.name = name;
        this.pipeSink = pipeSink;
        this.dataStartTime = dataStartTime;
        this.syncDelOp = syncDelOp;
        this.historyQueue = new BufferedPipeDataQueue(SyncPathUtil.getSenderHistoryPipeLogDir((String)name, (long)createTime));
        this.realTimeQueue = new BufferedPipeDataQueue(SyncPathUtil.getSenderRealTimePipeLogDir((String)name, (long)createTime));
        this.pipeLog = new TsFilePipeLogger(this);
        this.collectRealTimeDataLock = new ReentrantLock();
        this.maxSerialNumber = Math.max(0L, this.realTimeQueue.getLastMaxSerialNumber());
        this.status = Pipe.PipeStatus.STOP;
    }

    @Override
    public synchronized void start() throws PipeException {
        if (this.status == Pipe.PipeStatus.DROP) {
            throw new PipeException(String.format("Can not start pipe %s, because the pipe has been drop.", this.name));
        }
        if (this.status == Pipe.PipeStatus.RUNNING) {
            return;
        }
        List<DataRegion> dataRegions = StorageEngineV2.getInstance().getAllDataRegions();
        for (DataRegion dataRegion : dataRegions) {
            logger.info(this.logFormat("init syncManager for %s-%s", dataRegion.getStorageGroupName(), dataRegion.getDataRegionId()));
            this.syncManagerMap.put(dataRegion.getDataRegionId(), new LocalSyncManager(dataRegion, this));
        }
        try {
            if (!this.pipeLog.isCollectFinished()) {
                this.pipeLog.clear();
                this.collectHistoryData();
                this.pipeLog.finishCollect();
            }
            this.status = Pipe.PipeStatus.RUNNING;
        }
        catch (IOException e) {
            logger.error(this.logFormat("Clear pipe dir %s error.", SyncPathUtil.getSenderPipeDir((String)this.name, (long)this.createTime)), (Throwable)e);
            throw new PipeException("Start error, can not clear pipe log.");
        }
    }

    private void collectHistoryData() {
        ArrayList<File> historyTsFiles = new ArrayList<File>();
        for (ISyncManager syncManager : this.syncManagerMap.values()) {
            historyTsFiles.addAll(syncManager.syncHistoryTsFile(this.dataStartTime));
        }
        int historyTsFilesSize = historyTsFiles.size();
        for (int i = 0; i < historyTsFilesSize; ++i) {
            long serialNumber = 1 - historyTsFilesSize + i;
            File tsFile = (File)historyTsFiles.get(i);
            this.historyQueue.offer(new TsFilePipeData(tsFile.getParent(), tsFile.getName(), serialNumber));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createHistoryTsFileHardlink(File tsFile, long modsOffset) {
        this.collectRealTimeDataLock.lock();
        try {
            if (this.pipeLog.isHardlinkExist(tsFile)) {
                File file = null;
                return file;
            }
            File file = this.pipeLog.createTsFileAndModsHardlink(tsFile, modsOffset);
            return file;
        }
        catch (IOException e) {
            logger.error(this.logFormat("Create hardlink for history tsfile %s error.", tsFile.getPath()), (Throwable)e);
            File file = null;
            return file;
        }
        finally {
            this.collectRealTimeDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectRealTimeDeletion(Deletion deletion, String sgName) {
        this.collectRealTimeDataLock.lock();
        try {
            if (!this.syncDelOp) {
                return;
            }
            for (PartialPath deletePath : LocalSyncManager.splitPathPatternByDevice(deletion.getPath())) {
                Deletion splitDeletion = new Deletion(deletePath, deletion.getFileOffset(), deletion.getStartTime(), deletion.getEndTime());
                ++this.maxSerialNumber;
                DeletionPipeData deletionData = new DeletionPipeData(sgName, splitDeletion, this.maxSerialNumber);
                this.realTimeQueue.offer(deletionData);
            }
        }
        catch (MetadataException e) {
            logger.warn(this.logFormat("Collect deletion %s error.", deletion), (Throwable)e);
        }
        finally {
            this.collectRealTimeDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectRealTimeTsFile(File tsFile) {
        this.collectRealTimeDataLock.lock();
        try {
            if (this.pipeLog.isHardlinkExist(tsFile)) {
                return;
            }
            ++this.maxSerialNumber;
            File hardlink = this.pipeLog.createTsFileHardlink(tsFile);
            TsFilePipeData tsFileData = new TsFilePipeData(hardlink.getParent(), hardlink.getName(), this.maxSerialNumber);
            this.realTimeQueue.offer(tsFileData);
        }
        catch (IOException e) {
            logger.warn(this.logFormat("Create Hardlink tsfile %s on disk error, serial number is %d.", tsFile.getPath(), this.maxSerialNumber), (Throwable)e);
        }
        finally {
            this.collectRealTimeDataLock.unlock();
        }
    }

    public void collectRealTimeResource(File tsFile) {
        try {
            this.pipeLog.createTsFileResourceHardlink(tsFile);
        }
        catch (IOException e) {
            logger.warn(this.logFormat("Record tsfile resource %s on disk error.", tsFile.getPath()), (Throwable)e);
        }
    }

    @Override
    public PipeData take() throws InterruptedException {
        if (!this.historyQueue.isEmpty()) {
            return this.historyQueue.take();
        }
        return this.realTimeQueue.take();
    }

    public List<PipeData> pull(long serialNumber) {
        ArrayList<PipeData> pullPipeData = new ArrayList<PipeData>();
        if (!this.historyQueue.isEmpty()) {
            pullPipeData.addAll(this.historyQueue.pull(serialNumber));
        }
        if (serialNumber > 0L) {
            pullPipeData.addAll(this.realTimeQueue.pull(serialNumber));
        }
        return pullPipeData;
    }

    @Override
    public void commit() {
        if (!this.historyQueue.isEmpty()) {
            this.historyQueue.commit();
        }
        this.realTimeQueue.commit();
    }

    @Override
    public ISyncManager getOrCreateSyncManager(String dataRegionId) {
        return this.syncManagerMap.computeIfAbsent(dataRegionId, id -> new LocalSyncManager(StorageEngineV2.getInstance().getDataRegion(new DataRegionId(Integer.parseInt(id))), this));
    }

    @Override
    public void deleteSyncManager(String dataRegionId) {
        if (this.syncManagerMap.containsKey(dataRegionId)) {
            this.syncManagerMap.remove(dataRegionId).delete();
        }
    }

    public void commit(long serialNumber) {
        if (!this.historyQueue.isEmpty()) {
            this.historyQueue.commit(serialNumber);
        }
        if (serialNumber > 0L) {
            this.realTimeQueue.commit(serialNumber);
        }
    }

    @Override
    public synchronized void stop() throws PipeException {
        if (this.status == Pipe.PipeStatus.DROP) {
            throw new PipeException(String.format("Can not stop pipe %s, because the pipe is drop.", this.name));
        }
        this.status = Pipe.PipeStatus.STOP;
    }

    @Override
    public synchronized void drop() throws PipeException {
        if (this.status == Pipe.PipeStatus.DROP) {
            return;
        }
        this.clear();
        this.status = Pipe.PipeStatus.DROP;
    }

    private void clear() {
        try {
            this.historyQueue.clear();
            this.realTimeQueue.clear();
            this.pipeLog.clear();
        }
        catch (IOException e) {
            logger.warn(this.logFormat("Clear pipe %s %d error.", this.name, this.createTime), (Throwable)e);
        }
    }

    private String logFormat(String format, Object ... arguments) {
        return String.format(String.format("[%s-%s] ", this.name, this.createTime) + format, arguments);
    }

    @Override
    public void close() throws PipeException {
        if (this.status == Pipe.PipeStatus.DROP) {
            return;
        }
        this.historyQueue.close();
        this.realTimeQueue.close();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PipeSink getPipeSink() {
        return this.pipeSink;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public synchronized Pipe.PipeStatus getStatus() {
        return this.status;
    }

    public String toString() {
        return "TsFilePipe{createTime=" + this.createTime + ", name='" + this.name + '\'' + ", pipeSink=" + this.pipeSink + ", dataStartTime=" + this.dataStartTime + ", syncDelOp=" + this.syncDelOp + ", pipeLog=" + this.pipeLog + ", maxSerialNumber=" + this.maxSerialNumber + ", status=" + (Object)((Object)this.status) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsFilePipe that = (TsFilePipe)o;
        return this.createTime == that.createTime && Objects.equals(this.name, that.name) && Objects.equals(this.pipeSink, that.pipeSink);
    }

    public int hashCode() {
        return Objects.hash(this.createTime, this.name, this.pipeSink);
    }
}

