/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver.load;

import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.StorageGroupAlreadySetException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.sync.PipeDataLoadException;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.sync.receiver.load.ILoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaLoader
implements ILoader {
    private static final Logger logger = LoggerFactory.getLogger(SchemaLoader.class);
    private static PlanExecutor planExecutor;
    private final PhysicalPlan plan;

    public SchemaLoader(PhysicalPlan plan) {
        this.plan = plan;
    }

    @Override
    public void load() throws PipeDataLoadException {
        try {
            planExecutor.processNonQuery(this.plan);
        }
        catch (QueryProcessException e) {
            if (e.getCause() instanceof StorageGroupAlreadySetException) {
                logger.warn("Sync receiver try to set storage group " + ((StorageGroupAlreadySetException)((Object)e.getCause())).getStorageGroupPath() + " that has already been set");
            }
            throw new PipeDataLoadException(e.getMessage());
        }
        catch (StorageEngineException | StorageGroupNotSetException e) {
            throw new PipeDataLoadException(e.getMessage());
        }
    }

    static {
        try {
            planExecutor = new PlanExecutor();
        }
        catch (QueryProcessException e) {
            logger.error(e.getMessage());
        }
    }
}

