/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.ServerCommandLine;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.exception.ConfigurationException;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeConfigurationResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRemoveReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRemoveResp;
import org.apache.iotdb.db.client.ConfigNodeClient;
import org.apache.iotdb.db.client.ConfigNodeInfo;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.IoTDBStopCheck;
import org.apache.iotdb.db.service.DataNode;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeServerCommandLine
extends ServerCommandLine {
    private static final Logger logger = LoggerFactory.getLogger(DataNodeServerCommandLine.class);
    private static final String MODE_START = "-s";
    private static final String MODE_REMOVE = "-r";
    private static final String USAGE = "Usage: <-s|-r> [-D{} <configure folder>] \n-s: start the node to the cluster\n-r: remove the node out of the cluster\n";

    protected String getUsage() {
        return USAGE;
    }

    protected int run(String[] args) throws Exception {
        if (args.length < 1) {
            this.usage(null);
            return -1;
        }
        DataNode dataNode = DataNode.getInstance();
        try {
            dataNode.serverCheckAndInit();
        }
        catch (IOException | ConfigurationException e) {
            logger.error("meet error when doing start checking", e);
            return -1;
        }
        String mode = args[0];
        logger.info("Running mode {}", (Object)mode);
        if (!dataNode.initLocalEngines()) {
            logger.error("initLocalEngines error, stop process!");
            return -1;
        }
        if (MODE_START.equals(mode)) {
            dataNode.doAddNode();
        } else if (MODE_REMOVE.equals(mode)) {
            this.doRemoveNode(args);
        } else {
            logger.error("Unrecognized mode {}", (Object)mode);
        }
        return 0;
    }

    private void doRemoveNode(String[] args) throws Exception {
        this.removePrepare(args);
        this.removeNodesFromCluster(args);
        this.removeTail();
    }

    private void removePrepare(String[] args) throws BadNodeUrlException, TException {
        ConfigNodeInfo.getInstance().updateConfigNodeList(IoTDBDescriptor.getInstance().getConfig().getTargetConfigNodeList());
        try (ConfigNodeClient configNodeClient = new ConfigNodeClient();){
            TDataNodeConfigurationResp resp = configNodeClient.getDataNodeConfiguration(-1);
            Map nodeIdToNodeConfiguration = resp.getDataNodeConfigurationMap();
            List endPoints = NodeUrlUtils.parseTEndPointUrls((String)args[1]);
            List<String> removedDataNodeIps = endPoints.stream().map(TEndPoint::getIp).collect(Collectors.toList());
            List<String> onlineDataNodeIps = nodeIdToNodeConfiguration.values().stream().map(TDataNodeConfiguration::getLocation).map(TDataNodeLocation::getInternalEndPoint).map(TEndPoint::getIp).collect(Collectors.toList());
            IoTDBStopCheck.getInstance().checkIpInCluster(removedDataNodeIps, onlineDataNodeIps);
        }
    }

    private void removeNodesFromCluster(String[] args) throws BadNodeUrlException, TException, IoTDBException {
        logger.info("start to remove DataNode from cluster");
        List<TDataNodeLocation> dataNodeLocations = this.buildDataNodeLocations(args[1]);
        if (dataNodeLocations.isEmpty()) {
            throw new BadNodeUrlException("build DataNode location is empty");
        }
        logger.info("there has data nodes location will be removed. size is: {}, detail: {}", (Object)dataNodeLocations.size(), dataNodeLocations);
        TDataNodeRemoveReq removeReq = new TDataNodeRemoveReq(dataNodeLocations);
        try (ConfigNodeClient configNodeClient = new ConfigNodeClient();){
            TDataNodeRemoveResp removeResp = configNodeClient.removeDataNode(removeReq);
            logger.info("Remove result {} ", (Object)removeResp.toString());
            if (removeResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new IoTDBException(removeResp.getStatus().toString(), removeResp.getStatus().getCode());
            }
        }
    }

    private List<TDataNodeLocation> buildDataNodeLocations(String endPorts) throws BadNodeUrlException {
        List<Object> dataNodeLocations = new ArrayList<TDataNodeLocation>();
        if (endPorts == null || endPorts.trim().isEmpty()) {
            return dataNodeLocations;
        }
        List endPoints = NodeUrlUtils.parseTEndPointUrls((String)endPorts);
        try (ConfigNodeClient client = new ConfigNodeClient();){
            dataNodeLocations = client.getDataNodeConfiguration(-1).getDataNodeConfigurationMap().values().stream().map(TDataNodeConfiguration::getLocation).filter(location -> endPoints.contains(location.getClientRpcEndPoint())).collect(Collectors.toList());
        }
        catch (TException e) {
            logger.error("get data node locations failed", (Throwable)e);
        }
        if (endPoints.size() != dataNodeLocations.size()) {
            logger.error("build DataNode locations error, because number of input DataNode({}) NOT EQUALS the number of fetched DataNodeLocations({}), will return empty locations", (Object)endPoints.size(), (Object)dataNodeLocations.size());
            dataNodeLocations.clear();
            return dataNodeLocations;
        }
        return dataNodeLocations;
    }

    private void removeTail() {
    }
}

