/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.mpprest.filter;

import java.io.IOException;
import javax.servlet.annotation.WebFilter;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.authorizer.IAuthorizer;
import org.apache.iotdb.db.auth.AuthorizerManager;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceDescriptor;
import org.apache.iotdb.db.protocol.mpprest.filter.BasicSecurityContext;
import org.apache.iotdb.db.protocol.mpprest.filter.User;
import org.apache.iotdb.db.protocol.mpprest.filter.UserCache;
import org.apache.iotdb.db.protocol.mpprest.model.ExecutionStatus;
import org.apache.iotdb.rpc.TSStatusCode;
import org.glassfish.jersey.internal.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(value={"/*"})
@Provider
public class AuthorizationFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationFilter.class);
    private final IAuthorizer authorizer = AuthorizerManager.getInstance();
    private final UserCache userCache = UserCache.getInstance();

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        if ("OPTIONS".equals(containerRequestContext.getMethod()) || "swagger.json".equals(containerRequestContext.getUriInfo().getPath()) || "ping".equals(containerRequestContext.getUriInfo().getPath())) {
            return;
        }
        String authorizationHeader = containerRequestContext.getHeaderString("authorization");
        if (authorizationHeader == null) {
            Response resp = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/json").entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.UNINITIALIZED_AUTH_ERROR.getStatusCode())).message(TSStatusCode.UNINITIALIZED_AUTH_ERROR.name())).build();
            containerRequestContext.abortWith(resp);
            return;
        }
        User user = this.userCache.getUser(authorizationHeader);
        if (user == null) {
            user = this.checkLogin(containerRequestContext, authorizationHeader);
            if (user == null) {
                return;
            }
            this.userCache.setUser(authorizationHeader, user);
        }
        BasicSecurityContext basicSecurityContext = new BasicSecurityContext(user, IoTDBRestServiceDescriptor.getInstance().getConfig().isEnableHttps());
        containerRequestContext.setSecurityContext((SecurityContext)basicSecurityContext);
    }

    private User checkLogin(ContainerRequestContext containerRequestContext, String authorizationHeader) {
        String decoded = Base64.decodeAsString((String)authorizationHeader.replace("Basic ", ""));
        String[] split = decoded.split(":");
        if (split.length != 2) {
            Response resp = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/json").entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.SYSTEM_CHECK_ERROR.getStatusCode())).message(TSStatusCode.SYSTEM_CHECK_ERROR.name())).build();
            containerRequestContext.abortWith(resp);
            return null;
        }
        User user = new User();
        user.setUsername(split[0]);
        user.setPassword(split[1]);
        try {
            if (!this.authorizer.login(split[0], split[1])) {
                Response resp = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/json").entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.WRONG_LOGIN_PASSWORD_ERROR.getStatusCode())).message(TSStatusCode.WRONG_LOGIN_PASSWORD_ERROR.name())).build();
                containerRequestContext.abortWith(resp);
                return null;
            }
        }
        catch (AuthException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            Response resp = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/json").entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode())).message(e.getMessage())).build();
            containerRequestContext.abortWith(resp);
            return null;
        }
        return user;
    }
}

