/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.meta;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.utils.DataTypeUtils;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.influxdb.InfluxDBException;

public class TagInfoRecords {
    private static final String TAG_INFO_DEVICE_ID = "root.TAG_INFO";
    private static final List<String> TAG_INFO_MEASUREMENTS = new ArrayList<String>();
    private static final List<TSDataType> TAG_INFO_TYPES = new ArrayList<TSDataType>();
    private static final AtomicLong TAG_TIME_STAMPS = new AtomicLong();
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<Long> times = new ArrayList<Long>();
    private final List<List<String>> measurementsList = new ArrayList<List<String>>();
    private final List<List<TSDataType>> typesList = new ArrayList<List<TSDataType>>();
    private final List<List<Object>> valuesList = new ArrayList<List<Object>>();

    public void add(String database, String measurement, String tag, int order) {
        this.deviceIds.add(TAG_INFO_DEVICE_ID);
        this.times.add(TAG_TIME_STAMPS.getAndIncrement());
        this.measurementsList.add(TAG_INFO_MEASUREMENTS);
        this.typesList.add(TAG_INFO_TYPES);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(database);
        values.add(measurement);
        values.add(tag);
        values.add(order);
        this.valuesList.add(values);
    }

    public List<InsertRowPlan> convertToInsertRowPlans() {
        ArrayList<InsertRowPlan> insertRowPlans = new ArrayList<InsertRowPlan>();
        for (int i = 0; i < this.deviceIds.size(); ++i) {
            try {
                insertRowPlans.add(new InsertRowPlan(new PartialPath(this.deviceIds.get(i)), (long)this.times.get(i), this.measurementsList.get(i).toArray(new String[0]), DataTypeUtils.getValueBuffer(this.typesList.get(i), this.valuesList.get(i)), false));
                continue;
            }
            catch (IllegalPathException | QueryProcessException | IoTDBConnectionException e) {
                throw new InfluxDBException(((Throwable)e).getMessage());
            }
        }
        return insertRowPlans;
    }

    public List<TSInsertRecordReq> convertToInsertRecordsReq(long sessionID) throws IoTDBConnectionException {
        ArrayList<TSInsertRecordReq> reqs = new ArrayList<TSInsertRecordReq>();
        long now = 0L;
        for (int i = 0; i < this.deviceIds.size(); ++i) {
            TSInsertRecordReq tsInsertRecordReq = new TSInsertRecordReq();
            tsInsertRecordReq.setSessionId(sessionID);
            tsInsertRecordReq.setTimestamp(this.times.get(i).longValue());
            tsInsertRecordReq.setIsAligned(false);
            tsInsertRecordReq.setPrefixPath(this.deviceIds.get(i));
            tsInsertRecordReq.setMeasurements(this.measurementsList.get(i));
            tsInsertRecordReq.setValues(DataTypeUtils.getValueBuffer(this.typesList.get(i), this.valuesList.get(i)));
            reqs.add(tsInsertRecordReq);
        }
        return reqs;
    }

    static {
        TAG_INFO_MEASUREMENTS.add("database_name");
        TAG_INFO_MEASUREMENTS.add("measurement_name");
        TAG_INFO_MEASUREMENTS.add("tag_name");
        TAG_INFO_MEASUREMENTS.add("tag_order");
        TAG_INFO_TYPES.add(TSDataType.TEXT);
        TAG_INFO_TYPES.add(TSDataType.TEXT);
        TAG_INFO_TYPES.add(TSDataType.TEXT);
        TAG_INFO_TYPES.add(TSDataType.INT32);
    }
}

