/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.crud;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.plan.constant.StatementType;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class InsertRowStatement
extends InsertBaseStatement {
    private static final byte TYPE_RAW_STRING = -1;
    private static final byte TYPE_NULL = -2;
    private long time;
    private Object[] values;
    private boolean isNeedInferType = false;

    public InsertRowStatement() {
        this.statementType = StatementType.INSERT;
    }

    @Override
    public List<PartialPath> getPaths() {
        ArrayList<PartialPath> ret = new ArrayList<PartialPath>();
        for (String m : this.measurements) {
            PartialPath fullPath = this.devicePath.concatNode(m);
            ret.add(fullPath);
        }
        return ret;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    public boolean isNeedInferType() {
        return this.isNeedInferType;
    }

    public void setNeedInferType(boolean needInferType) {
        this.isNeedInferType = needInferType;
    }

    @Override
    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public void fillValues(ByteBuffer buffer) throws QueryProcessException {
        this.values = new Object[this.measurements.length];
        this.dataTypes = new TSDataType[this.measurements.length];
        block8: for (int i = 0; i < this.dataTypes.length; ++i) {
            byte typeNum = (byte)ReadWriteIOUtils.read((ByteBuffer)buffer);
            if (typeNum == -1 || typeNum == -2) {
                this.values[i] = typeNum == -1 ? ReadWriteIOUtils.readString((ByteBuffer)buffer) : null;
                continue;
            }
            this.dataTypes[i] = TSDataType.values()[typeNum];
            switch (this.dataTypes[i]) {
                case BOOLEAN: {
                    this.values[i] = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
                    continue block8;
                }
                case INT32: {
                    this.values[i] = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
                    continue block8;
                }
                case INT64: {
                    this.values[i] = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
                    continue block8;
                }
                case FLOAT: {
                    this.values[i] = Float.valueOf(ReadWriteIOUtils.readFloat((ByteBuffer)buffer));
                    continue block8;
                }
                case DOUBLE: {
                    this.values[i] = ReadWriteIOUtils.readDouble((ByteBuffer)buffer);
                    continue block8;
                }
                case TEXT: {
                    this.values[i] = ReadWriteIOUtils.readBinary((ByteBuffer)buffer);
                    continue block8;
                }
                default: {
                    throw new QueryProcessException("Unsupported data type:" + this.dataTypes[i]);
                }
            }
        }
    }

    public List<TTimePartitionSlot> getTimePartitionSlots() {
        return Collections.singletonList(StorageEngineV2.getTimePartitionSlot(this.time));
    }

    @Override
    public List<TEndPoint> collectRedirectInfo(DataPartition dataPartition) {
        TRegionReplicaSet regionReplicaSet = dataPartition.getDataRegionReplicaSetForWriting(this.devicePath.getFullPath(), StorageEngineV2.getTimePartitionSlot(this.time));
        return Collections.singletonList(((TDataNodeLocation)regionReplicaSet.getDataNodeLocations().get(0)).getClientRpcEndPoint());
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitInsertRow(this, context);
    }
}

