/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.LevelTimeSeriesCountOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class CountMergeOperator
implements ProcessOperator {
    private final PlanNodeId planNodeId;
    private final OperatorContext operatorContext;
    private boolean isFinished;
    private final List<Operator> children;

    public CountMergeOperator(PlanNodeId planNodeId, OperatorContext operatorContext, List<Operator> children) {
        this.planNodeId = planNodeId;
        this.operatorContext = operatorContext;
        this.children = children;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ArrayList listenableFutures = new ArrayList();
        for (Operator child : this.children) {
            ListenableFuture<?> blocked = child.isBlocked();
            if (blocked.isDone()) continue;
            listenableFutures.add(blocked);
        }
        return listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
    }

    @Override
    public TsBlock next() {
        this.isFinished = true;
        if (this.children.get(0) instanceof LevelTimeSeriesCountOperator) {
            return this.nextWithGroupByLevel();
        }
        return this.nextWithoutGroupByLevel();
    }

    private TsBlock nextWithoutGroupByLevel() {
        ArrayList<TsBlock> tsBlocks = new ArrayList<TsBlock>(this.children.size());
        for (Operator operator : this.children) {
            if (!operator.hasNext()) continue;
            tsBlocks.add(operator.next());
        }
        int totalCount = 0;
        for (TsBlock tsBlock : tsBlocks) {
            int count = tsBlock.getColumn(0).getInt(0);
            totalCount += count;
        }
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
        tsBlockBuilder.getColumnBuilder(0).writeInt(totalCount);
        tsBlockBuilder.declarePosition();
        return tsBlockBuilder.build();
    }

    private TsBlock nextWithGroupByLevel() {
        ArrayList<TsBlock> tsBlocks = new ArrayList<TsBlock>(this.children.size());
        for (Operator child : this.children) {
            if (!child.hasNext()) continue;
            tsBlocks.add(child.next());
        }
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(Arrays.asList(TSDataType.TEXT, TSDataType.INT32));
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (TsBlock tsBlock : tsBlocks) {
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                String columnName = tsBlock.getColumn(0).getBinary(i).getStringValue();
                int count2 = tsBlock.getColumn(1).getInt(i);
                countMap.put(columnName, countMap.getOrDefault(columnName, 0) + count2);
            }
        }
        countMap.forEach((column, count) -> {
            tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
            tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary(column));
            tsBlockBuilder.getColumnBuilder(1).writeInt(count.intValue());
            tsBlockBuilder.declarePosition();
        });
        return tsBlockBuilder.build();
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public long calculateMaxPeekMemory() {
        long childrenMaxPeekMemory = 0L;
        for (Operator child : this.children) {
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, child.calculateMaxPeekMemory());
        }
        return childrenMaxPeekMemory;
    }

    @Override
    public long calculateMaxReturnSize() {
        long childrenMaxReturnSize = 0L;
        for (Operator child : this.children) {
            childrenMaxReturnSize = Math.max(childrenMaxReturnSize, child.calculateMaxReturnSize());
        }
        return childrenMaxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long retainedSize = 0L;
        for (Operator child : this.children) {
            retainedSize += child.calculateRetainedSizeAfterCallingNext();
        }
        return retainedSize;
    }
}

