/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.mpp.aggregation.Aggregator;
import org.apache.iotdb.db.mpp.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.mpp.execution.operator.AggregationUtil;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;

public class AggregationOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final List<Operator> children;
    private final int inputOperatorsCount;
    private final TsBlock[] inputTsBlocks;
    private final boolean[] canCallNext;
    private final ITimeRangeIterator timeRangeIterator;
    private TimeRange curTimeRange;
    private final List<Aggregator> aggregators;
    private final TsBlockBuilder resultTsBlockBuilder;
    private final long maxRetainedSize;
    private final long childrenRetainedSize;
    private final long maxReturnSize;

    public AggregationOperator(OperatorContext operatorContext, List<Aggregator> aggregators, ITimeRangeIterator timeRangeIterator, List<Operator> children, long maxReturnSize) {
        this.operatorContext = operatorContext;
        this.children = children;
        this.aggregators = aggregators;
        this.timeRangeIterator = timeRangeIterator;
        this.inputOperatorsCount = children.size();
        this.inputTsBlocks = new TsBlock[this.inputOperatorsCount];
        this.canCallNext = new boolean[this.inputOperatorsCount];
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            this.canCallNext[i] = false;
        }
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (Aggregator aggregator : aggregators) {
            dataTypes.addAll(Arrays.asList(aggregator.getOutputType()));
        }
        this.resultTsBlockBuilder = new TsBlockBuilder(dataTypes);
        this.maxRetainedSize = children.stream().mapToLong(Operator::calculateMaxReturnSize).sum();
        this.childrenRetainedSize = children.stream().mapToLong(Operator::calculateRetainedSizeAfterCallingNext).sum();
        this.maxReturnSize = maxReturnSize;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.maxReturnSize + this.maxRetainedSize + this.childrenRetainedSize;
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.maxRetainedSize + this.childrenRetainedSize;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ArrayList listenableFutures = new ArrayList();
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            ListenableFuture<?> blocked = this.children.get(i).isBlocked();
            if (blocked.isDone()) {
                this.canCallNext[i] = true;
                continue;
            }
            if (!this.isEmpty(i)) continue;
            listenableFutures.add(blocked);
            this.canCallNext[i] = true;
        }
        return listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
    }

    @Override
    public boolean hasNext() {
        return this.curTimeRange != null || this.timeRangeIterator.hasNextTimeRange();
    }

    @Override
    public TsBlock next() {
        boolean hasCachedData;
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        while (System.nanoTime() - start < maxRuntime && (this.curTimeRange != null || this.timeRangeIterator.hasNextTimeRange()) && !this.resultTsBlockBuilder.isFull() && (hasCachedData = this.prepareInput())) {
            if (this.curTimeRange == null && this.timeRangeIterator.hasNextTimeRange()) {
                this.curTimeRange = this.timeRangeIterator.nextTimeRange();
                for (Aggregator aggregator : this.aggregators) {
                    aggregator.updateTimeRange(this.curTimeRange);
                }
            }
            this.calculateNextAggregationResult();
        }
        if (this.resultTsBlockBuilder.getPositionCount() > 0) {
            TsBlock resultTsBlock = this.resultTsBlockBuilder.build();
            this.resultTsBlockBuilder.reset();
            return resultTsBlock;
        }
        return null;
    }

    @Override
    public boolean isFinished() {
        return !this.hasNext();
    }

    @Override
    public void close() throws Exception {
        for (Operator child : this.children) {
            child.close();
        }
    }

    private boolean prepareInput() {
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.inputTsBlocks[i] != null) continue;
            if (!this.canCallNext[i]) {
                return false;
            }
            this.inputTsBlocks[i] = this.children.get(i).next();
            this.canCallNext[i] = false;
            if (this.inputTsBlocks[i] != null) continue;
            return false;
        }
        return true;
    }

    private void calculateNextAggregationResult() {
        for (Aggregator aggregator : this.aggregators) {
            aggregator.processTsBlocks(this.inputTsBlocks);
        }
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            this.inputTsBlocks[i] = this.inputTsBlocks[i].skipFirst();
            if (!this.inputTsBlocks[i].isEmpty()) continue;
            this.inputTsBlocks[i] = null;
        }
        this.updateResultTsBlock();
    }

    private void updateResultTsBlock() {
        this.curTimeRange = null;
        AggregationUtil.appendAggregationResult(this.resultTsBlockBuilder, this.aggregators, this.timeRangeIterator);
    }

    private boolean isEmpty(int index) {
        return this.inputTsBlocks[index] == null || this.inputTsBlocks[index].isEmpty();
    }
}

