/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common.header;

import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class DatasetHeader {
    public static DatasetHeader EMPTY_HEADER = new DatasetHeader(new ArrayList<ColumnHeader>(), false);
    private final List<ColumnHeader> columnHeaders;
    private final boolean isIgnoreTimestamp;
    private Map<String, Integer> columnToTsBlockIndexMap;

    public DatasetHeader(List<ColumnHeader> columnHeaders, boolean isIgnoreTimestamp) {
        this.columnHeaders = columnHeaders;
        this.isIgnoreTimestamp = isIgnoreTimestamp;
    }

    public List<ColumnHeader> getColumnHeaders() {
        return this.columnHeaders;
    }

    public boolean isIgnoreTimestamp() {
        return this.isIgnoreTimestamp;
    }

    public void setColumnToTsBlockIndexMap(List<String> outputColumnNames) {
        this.columnToTsBlockIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < outputColumnNames.size(); ++i) {
            this.columnToTsBlockIndexMap.put(outputColumnNames.get(i), i);
        }
    }

    public List<String> getRespColumns() {
        return this.columnHeaders.stream().map(ColumnHeader::getColumnNameWithAlias).collect(Collectors.toList());
    }

    public List<String> getColumnNameWithoutAlias() {
        return this.columnHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList());
    }

    public List<String> getRespDataTypeList() {
        return this.columnHeaders.stream().map(ColumnHeader::getColumnType).map(Objects::toString).collect(Collectors.toList());
    }

    public List<TSDataType> getRespDataTypes() {
        return this.columnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
    }

    public List<Byte> getRespAliasColumns() {
        BitSet aliasMap = new BitSet();
        for (int i = 0; i < this.columnHeaders.size(); ++i) {
            if (!this.columnHeaders.get(i).hasAlias()) continue;
            aliasMap.set(i);
        }
        return new ArrayList<Byte>(Bytes.asList((byte[])aliasMap.toByteArray()));
    }

    public Map<String, Integer> getColumnNameIndexMap() {
        if (this.columnToTsBlockIndexMap == null || this.columnToTsBlockIndexMap.isEmpty()) {
            return this.columnToTsBlockIndexMap;
        }
        HashMap<String, Integer> columnNameIndexMap = new HashMap<String, Integer>();
        for (ColumnHeader columnHeader : this.columnHeaders) {
            columnNameIndexMap.put(columnHeader.getColumnNameWithAlias(), this.columnToTsBlockIndexMap.get(columnHeader.getColumnName()));
        }
        return columnNameIndexMap;
    }

    public int getOutputValueColumnCount() {
        return (int)this.columnHeaders.stream().map(ColumnHeader::getColumnName).distinct().count();
    }
}

