/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.mpp.aggregation.Accumulator;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class MaxValueAccumulator
implements Accumulator {
    private TSDataType seriesDataType;
    private TsPrimitiveType maxResult;
    private boolean initResult;

    public MaxValueAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
        this.maxResult = TsPrimitiveType.getByType((TSDataType)seriesDataType);
    }

    @Override
    public int addInput(Column[] column, TimeRange timeRange) {
        switch (this.seriesDataType) {
            case INT32: {
                return this.addIntInput(column, timeRange);
            }
            case INT64: {
                return this.addLongInput(column, timeRange);
            }
            case FLOAT: {
                return this.addFloatInput(column, timeRange);
            }
            case DOUBLE: {
                return this.addDoubleInput(column, timeRange);
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in MaxValue: %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 1 ? 1 : 0) != 0, (Object)"partialResult of MaxValue should be 1");
        if (partialResult[0].isNull(0)) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                this.updateIntResult(partialResult[0].getInt(0));
                break;
            }
            case INT64: {
                this.updateLongResult(partialResult[0].getLong(0));
                break;
            }
            case FLOAT: {
                this.updateFloatResult(partialResult[0].getFloat(0));
                break;
            }
            case DOUBLE: {
                this.updateDoubleResult(partialResult[0].getDouble(0));
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in MaxValue: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void addStatistics(Statistics statistics) {
        if (statistics == null) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                this.updateIntResult((Integer)statistics.getMaxValue());
                break;
            }
            case INT64: {
                this.updateLongResult((Long)statistics.getMaxValue());
                break;
            }
            case FLOAT: {
                this.updateFloatResult(((Float)statistics.getMaxValue()).floatValue());
                break;
            }
            case DOUBLE: {
                this.updateDoubleResult((Double)statistics.getMaxValue());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in MaxValue: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void setFinal(Column finalResult) {
        if (finalResult.isNull(0)) {
            return;
        }
        this.maxResult.setObject(finalResult.getObject(0));
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 1 ? 1 : 0) != 0, (Object)"partialResult of MaxValue should be 1");
        if (!this.initResult) {
            columnBuilders[0].appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                columnBuilders[0].writeInt(this.maxResult.getInt());
                break;
            }
            case INT64: {
                columnBuilders[0].writeLong(this.maxResult.getLong());
                break;
            }
            case FLOAT: {
                columnBuilders[0].writeFloat(this.maxResult.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilders[0].writeDouble(this.maxResult.getDouble());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in MaxValue: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: {
                columnBuilder.writeInt(this.maxResult.getInt());
                break;
            }
            case INT64: {
                columnBuilder.writeLong(this.maxResult.getLong());
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.maxResult.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.maxResult.getDouble());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in MaxValue: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.maxResult.reset();
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{this.maxResult.getDataType()};
    }

    @Override
    public TSDataType getFinalType() {
        return this.maxResult.getDataType();
    }

    private int addIntInput(Column[] column, TimeRange timeRange) {
        TimeColumn timeColumn = (TimeColumn)column[0];
        int curPositionCount = timeColumn.getPositionCount();
        long curMinTime = timeRange.getMin();
        long curMaxTime = timeRange.getMax();
        for (int i = 0; i < curPositionCount; ++i) {
            long curTime = timeColumn.getLong(i);
            if (curTime > curMaxTime || curTime < curMinTime) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.updateIntResult(column[1].getInt(i));
        }
        return timeColumn.getPositionCount();
    }

    private void updateIntResult(int maxVal) {
        if (!this.initResult || maxVal > this.maxResult.getInt()) {
            this.initResult = true;
            this.maxResult.setInt(maxVal);
        }
    }

    private int addLongInput(Column[] column, TimeRange timeRange) {
        TimeColumn timeColumn = (TimeColumn)column[0];
        int curPositionCount = timeColumn.getPositionCount();
        long curMinTime = timeRange.getMin();
        long curMaxTime = timeRange.getMax();
        for (int i = 0; i < curPositionCount; ++i) {
            long curTime = timeColumn.getLong(i);
            if (curTime > curMaxTime || curTime < curMinTime) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.updateLongResult(column[1].getLong(i));
        }
        return timeColumn.getPositionCount();
    }

    private void updateLongResult(long maxVal) {
        if (!this.initResult || maxVal > this.maxResult.getLong()) {
            this.initResult = true;
            this.maxResult.setLong(maxVal);
        }
    }

    private int addFloatInput(Column[] column, TimeRange timeRange) {
        TimeColumn timeColumn = (TimeColumn)column[0];
        int curPositionCount = timeColumn.getPositionCount();
        long curMinTime = timeRange.getMin();
        long curMaxTime = timeRange.getMax();
        for (int i = 0; i < curPositionCount; ++i) {
            long curTime = timeColumn.getLong(i);
            if (curTime > curMaxTime || curTime < curMinTime) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.updateFloatResult(column[1].getFloat(i));
        }
        return timeColumn.getPositionCount();
    }

    private void updateFloatResult(float maxVal) {
        if (!this.initResult || maxVal > this.maxResult.getFloat()) {
            this.initResult = true;
            this.maxResult.setFloat(maxVal);
        }
    }

    private int addDoubleInput(Column[] column, TimeRange timeRange) {
        TimeColumn timeColumn = (TimeColumn)column[0];
        int curPositionCount = timeColumn.getPositionCount();
        long curMinTime = timeRange.getMin();
        long curMaxTime = timeRange.getMax();
        for (int i = 0; i < curPositionCount; ++i) {
            long curTime = timeColumn.getLong(i);
            if (curTime > curMaxTime || curTime < curMinTime) {
                return i;
            }
            if (column[1].isNull(i)) continue;
            this.updateDoubleResult(column[1].getDouble(i));
        }
        return timeColumn.getPositionCount();
    }

    private void updateDoubleResult(double maxVal) {
        if (!this.initResult || maxVal > this.maxResult.getDouble()) {
            this.initResult = true;
            this.maxResult.setDouble(maxVal);
        }
    }
}

