/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser.counter;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.IMTreeStore;
import org.apache.iotdb.db.metadata.mtree.traverser.counter.CounterTraverser;

public class MeasurementCounter
extends CounterTraverser {
    private List<String> timeseries = new ArrayList<String>();
    private boolean hasTag = false;

    public MeasurementCounter(IMNode startNode, PartialPath path, IMTreeStore store) throws MetadataException {
        super(startNode, path, store);
        this.shouldTraverseTemplate = true;
    }

    public MeasurementCounter(IMNode startNode, PartialPath path, IMTreeStore store, List<String> timeseries, boolean hasTag) throws MetadataException {
        super(startNode, path, store);
        this.shouldTraverseTemplate = true;
        this.timeseries = timeseries;
        this.hasTag = hasTag;
    }

    @Override
    protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) {
        return false;
    }

    @Override
    protected boolean processFullMatchedMNode(IMNode node, int idx, int level) {
        if (!node.isMeasurement()) {
            return false;
        }
        if (this.hasTag && !this.timeseries.contains(node.getFullPath())) {
            return true;
        }
        ++this.count;
        return true;
    }
}

