/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.executor;

import java.lang.reflect.InvocationTargetException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.trigger.service.TriggerClassLoader;
import org.apache.iotdb.db.engine.trigger.api.Trigger;
import org.apache.iotdb.db.engine.trigger.executor.TriggerEvent;
import org.apache.iotdb.db.engine.trigger.service.TriggerRegistrationInformation;
import org.apache.iotdb.db.exception.TriggerExecutionException;
import org.apache.iotdb.db.exception.TriggerManagementException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.trigger.api.TriggerAttributes;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;

public class TriggerExecutor {
    private final TriggerRegistrationInformation registrationInformation;
    private final TriggerAttributes attributes;
    private final TriggerClassLoader classLoader;
    private final IMNode imNode;
    private final Trigger trigger;

    public TriggerExecutor(TriggerRegistrationInformation registrationInformation, TriggerClassLoader classLoader, IMNode imNode) throws TriggerManagementException {
        this.registrationInformation = registrationInformation;
        this.attributes = new TriggerAttributes(registrationInformation.getAttributes());
        this.classLoader = classLoader;
        this.imNode = imNode;
        this.trigger = this.constructTriggerInstance();
    }

    private Trigger constructTriggerInstance() throws TriggerManagementException {
        try {
            Class<?> triggerClass = Class.forName(this.registrationInformation.getClassName(), true, (ClassLoader)this.classLoader);
            return (Trigger)triggerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TriggerManagementException(String.format("Failed to reflect Trigger %s(%s) instance, because %s", this.registrationInformation.getTriggerName(), this.registrationInformation.getClassName(), e));
        }
    }

    public void onCreate() throws TriggerExecutionException {
        Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
        try {
            this.trigger.onCreate(this.attributes);
        }
        catch (Exception e) {
            this.onTriggerExecutionError("onConfig(TriggerAttributes)", e);
        }
        this.registrationInformation.markAsStarted();
    }

    public synchronized void onDrop() throws TriggerExecutionException {
        Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
        this.registrationInformation.markAsStopped();
        try {
            this.trigger.onDrop();
        }
        catch (Exception e) {
            this.onTriggerExecutionError("onConfig(TriggerAttributes)", e);
        }
    }

    public synchronized void onStart() throws TriggerExecutionException {
        this.invokeOnStart();
        this.registrationInformation.markAsStarted();
    }

    private void invokeOnStart() throws TriggerExecutionException {
        Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
        try {
            this.trigger.onStart();
        }
        catch (Exception e) {
            this.onTriggerExecutionError("onStart()", e);
        }
    }

    public synchronized void onStop() throws TriggerExecutionException {
        this.registrationInformation.markAsStopped();
        this.invokeOnStop();
    }

    private void invokeOnStop() throws TriggerExecutionException {
        Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
        try {
            this.trigger.onStop();
        }
        catch (Exception e) {
            this.onTriggerExecutionError("onStop()", e);
        }
    }

    public void fireIfActivated(TriggerEvent event, long timestamp, Object value, TSDataType seriesDataType, PartialPath path) throws TriggerExecutionException {
        if (!this.registrationInformation.isStopped() && event.equals((Object)this.registrationInformation.getEvent())) {
            this.fire(timestamp, value, seriesDataType, path);
        }
    }

    private synchronized void fire(long timestamp, Object value, TSDataType seriesDataType, PartialPath path) throws TriggerExecutionException {
        Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
        try {
            switch (seriesDataType) {
                case INT32: {
                    this.trigger.fire(timestamp, (Integer)value, path);
                    break;
                }
                case INT64: {
                    this.trigger.fire(timestamp, (Long)value, path);
                    break;
                }
                case FLOAT: {
                    this.trigger.fire(timestamp, (Float)value, path);
                    break;
                }
                case DOUBLE: {
                    this.trigger.fire(timestamp, (Double)value, path);
                    break;
                }
                case BOOLEAN: {
                    this.trigger.fire(timestamp, (Boolean)value, path);
                    break;
                }
                case TEXT: {
                    this.trigger.fire(timestamp, (Binary)value, path);
                    break;
                }
                default: {
                    throw new TriggerExecutionException("Unsupported series data type.");
                }
            }
        }
        catch (TriggerExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            this.onTriggerExecutionError("fire(long, Object)", e);
        }
    }

    public void fireIfActivated(TriggerEvent event, long[] timestamps, Object values, TSDataType seriesDataType, PartialPath path) throws TriggerExecutionException {
        if (!this.registrationInformation.isStopped() && event.equals((Object)this.registrationInformation.getEvent())) {
            this.fire(timestamps, values, seriesDataType, path);
        }
    }

    private synchronized void fire(long[] timestamps, Object values, TSDataType seriesDataType, PartialPath path) throws TriggerExecutionException {
        Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
        try {
            switch (seriesDataType) {
                case INT32: {
                    this.trigger.fire(timestamps, (int[])values, path);
                    break;
                }
                case INT64: {
                    this.trigger.fire(timestamps, (long[])values, path);
                    break;
                }
                case FLOAT: {
                    this.trigger.fire(timestamps, (float[])values, path);
                    break;
                }
                case DOUBLE: {
                    this.trigger.fire(timestamps, (double[])values, path);
                    break;
                }
                case BOOLEAN: {
                    this.trigger.fire(timestamps, (boolean[])values, path);
                    break;
                }
                case TEXT: {
                    this.trigger.fire(timestamps, (Binary[])values, path);
                    break;
                }
                default: {
                    throw new TriggerExecutionException("Unsupported series data type.");
                }
            }
        }
        catch (TriggerExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            this.onTriggerExecutionError("fire(long[], Object)", e);
        }
    }

    private void onTriggerExecutionError(String methodName, Exception e) throws TriggerExecutionException {
        throw new TriggerExecutionException(String.format("Error occurred during executing Trigger#%s: %s", methodName, System.lineSeparator()) + e);
    }

    public TriggerRegistrationInformation getRegistrationInformation() {
        return this.registrationInformation;
    }

    public IMNode getIMNode() {
        return this.imNode;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }
}

