/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup.timeindex;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.PartitionViolationException;

public interface ITimeIndex {
    public static final int SPANS_MULTI_TIME_PARTITIONS_FLAG_ID = -1;

    public void serialize(OutputStream var1) throws IOException;

    public ITimeIndex deserialize(InputStream var1) throws IOException;

    public ITimeIndex deserialize(ByteBuffer var1);

    public void close();

    public Set<String> getDevices(String var1, TsFileResource var2);

    public boolean endTimeEmpty();

    public boolean stillLives(long var1);

    public long calculateRamSize();

    public long getTimePartition(String var1);

    public long getTimePartitionWithCheck(String var1) throws PartitionViolationException;

    public boolean isSpanMultiTimePartitions();

    public void updateStartTime(String var1, long var2);

    public void updateEndTime(String var1, long var2);

    public void putStartTime(String var1, long var2);

    public void putEndTime(String var1, long var2);

    public long getStartTime(String var1);

    public long getEndTime(String var1);

    public boolean checkDeviceIdExist(String var1);

    public long getMinStartTime();

    public long getMaxEndTime();

    public int compareDegradePriority(ITimeIndex var1);

    public boolean mayContainsDevice(String var1);
}

