/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.snapshot;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

public class SnapshotLogger
implements AutoCloseable {
    public static final String SNAPSHOT_LOG_NAME = "snapshot.log";
    public static final String SPLIT_CHAR = "#";
    private File logFile;
    private BufferedOutputStream os;

    public SnapshotLogger(File logFile) throws IOException {
        this.logFile = logFile;
        if (!logFile.getParentFile().exists() && !logFile.getParentFile().mkdirs()) {
            throw new IOException("Cannot create parent folder for " + logFile.getAbsolutePath());
        }
        if (!this.logFile.createNewFile()) {
            throw new IOException("Cannot create file " + logFile.getAbsolutePath());
        }
        this.os = new BufferedOutputStream(new FileOutputStream(logFile));
    }

    @Override
    public void close() throws Exception {
        this.os.close();
    }

    public void logFile(String sourceFile, String linkFile) throws IOException {
        this.os.write(sourceFile.getBytes(StandardCharsets.UTF_8));
        this.os.write(SPLIT_CHAR.getBytes(StandardCharsets.UTF_8));
        this.os.write(linkFile.getBytes(StandardCharsets.UTF_8));
        this.os.write("\n".getBytes(StandardCharsets.UTF_8));
        this.os.flush();
    }

    public void cleanUpWhenFailed() throws IOException {
        this.os.close();
        Files.delete(this.logFile.toPath());
    }
}

