/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.modification;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class Deletion
extends Modification {
    private long startTime;
    private long endTime;

    public Deletion(PartialPath path, long fileOffset, long endTime) {
        super(Modification.Type.DELETION, path, fileOffset);
        this.startTime = Long.MIN_VALUE;
        this.endTime = endTime;
    }

    public Deletion(PartialPath path, long fileOffset, long startTime, long endTime) {
        super(Modification.Type.DELETION, path, fileOffset);
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long timestamp) {
        this.startTime = timestamp;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long timestamp) {
        this.endTime = timestamp;
    }

    public long serializeWithoutFileOffset(DataOutputStream stream) throws IOException {
        long serializeSize = 0L;
        stream.writeLong(this.startTime);
        serializeSize += 8L;
        stream.writeLong(this.endTime);
        serializeSize += 8L;
        return serializeSize += (long)ReadWriteIOUtils.write((String)this.getPathString(), (OutputStream)stream);
    }

    public static Deletion deserializeWithoutFileOffset(DataInputStream stream) throws IOException, IllegalPathException {
        long startTime = stream.readLong();
        long endTime = stream.readLong();
        return new Deletion(new PartialPath(ReadWriteIOUtils.readString((InputStream)stream)), 0L, startTime, endTime);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Deletion)) {
            return false;
        }
        Deletion del = (Deletion)obj;
        return super.equals(obj) && del.startTime == this.startTime && del.endTime == this.endTime;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.startTime, this.endTime);
    }

    public String toString() {
        return "Deletion{startTime=" + this.startTime + ", endTime=" + this.endTime + ", type=" + (Object)((Object)this.type) + ", path=" + this.path + ", fileOffset=" + this.fileOffset + '}';
    }
}

