/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.writer;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.constant.CompactionType;
import org.apache.iotdb.db.engine.compaction.constant.ProcessChunkType;
import org.apache.iotdb.db.engine.compaction.writer.CrossSpaceCompactionWriter;
import org.apache.iotdb.db.service.metrics.recorder.CompactionMetricsRecorder;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.chunk.IChunkWriter;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public abstract class AbstractCompactionWriter
implements AutoCloseable {
    protected static final int subTaskNum = IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum();
    protected IChunkWriter[] chunkWriters = new IChunkWriter[subTaskNum];
    protected boolean isAlign;
    protected String deviceId;
    private final long targetChunkSize = IoTDBDescriptor.getInstance().getConfig().getTargetChunkSize();
    protected int[] measurementPointCountArray = new int[subTaskNum];

    public abstract void startChunkGroup(String var1, boolean var2) throws IOException;

    public abstract void endChunkGroup() throws IOException;

    public void startMeasurement(List<IMeasurementSchema> measurementSchemaList, int subTaskId) {
        this.measurementPointCountArray[subTaskId] = 0;
        this.chunkWriters[subTaskId] = this.isAlign ? new AlignedChunkWriterImpl(measurementSchemaList) : new ChunkWriterImpl(measurementSchemaList.get(0), true);
    }

    public abstract void endMeasurement(int var1) throws IOException;

    public abstract void write(long var1, Object var3, int var4) throws IOException;

    public abstract void write(TimeColumn var1, Column[] var2, int var3, int var4) throws IOException;

    public abstract void endFile() throws IOException;

    @Override
    public abstract void close() throws IOException;

    protected void writeDataPoint(Long timestamp, Object value, int subTaskId) {
        if (!this.isAlign) {
            ChunkWriterImpl chunkWriter = (ChunkWriterImpl)this.chunkWriters[subTaskId];
            switch (chunkWriter.getDataType()) {
                case TEXT: {
                    chunkWriter.write(timestamp.longValue(), (Binary)value);
                    break;
                }
                case DOUBLE: {
                    chunkWriter.write(timestamp.longValue(), ((Double)value).doubleValue());
                    break;
                }
                case BOOLEAN: {
                    chunkWriter.write(timestamp.longValue(), ((Boolean)value).booleanValue());
                    break;
                }
                case INT64: {
                    chunkWriter.write(timestamp.longValue(), ((Long)value).longValue());
                    break;
                }
                case INT32: {
                    chunkWriter.write(timestamp.longValue(), ((Integer)value).intValue());
                    break;
                }
                case FLOAT: {
                    chunkWriter.write(timestamp.longValue(), ((Float)value).floatValue());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown data type " + chunkWriter.getDataType());
                }
            }
        } else {
            AlignedChunkWriterImpl chunkWriter = (AlignedChunkWriterImpl)this.chunkWriters[subTaskId];
            block16: for (TsPrimitiveType val : (TsPrimitiveType[])value) {
                if (val == null) {
                    chunkWriter.write(timestamp.longValue(), null, true);
                    continue;
                }
                TSDataType tsDataType = chunkWriter.getCurrentValueChunkType();
                switch (tsDataType) {
                    case TEXT: {
                        chunkWriter.write(timestamp.longValue(), val.getBinary(), false);
                        continue block16;
                    }
                    case DOUBLE: {
                        chunkWriter.write(timestamp.longValue(), val.getDouble(), false);
                        continue block16;
                    }
                    case BOOLEAN: {
                        chunkWriter.write(timestamp.longValue(), val.getBoolean(), false);
                        continue block16;
                    }
                    case INT64: {
                        chunkWriter.write(timestamp.longValue(), val.getLong(), false);
                        continue block16;
                    }
                    case INT32: {
                        chunkWriter.write(timestamp.longValue(), val.getInt(), false);
                        continue block16;
                    }
                    case FLOAT: {
                        chunkWriter.write(timestamp.longValue(), val.getFloat(), false);
                        continue block16;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown data type " + tsDataType);
                    }
                }
            }
            chunkWriter.write(timestamp.longValue());
        }
        int n = subTaskId;
        this.measurementPointCountArray[n] = this.measurementPointCountArray[n] + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushChunkToFileWriter(TsFileIOWriter targetWriter, int subTaskId) throws IOException {
        this.writeRateLimit(this.chunkWriters[subTaskId].estimateMaxSeriesMemSize());
        TsFileIOWriter tsFileIOWriter = targetWriter;
        synchronized (tsFileIOWriter) {
            this.chunkWriters[subTaskId].writeToFileWriter(targetWriter);
        }
    }

    protected void checkChunkSizeAndMayOpenANewChunk(TsFileIOWriter fileWriter, int subTaskId) throws IOException {
        if (this.checkChunkSize(subTaskId)) {
            this.flushChunkToFileWriter(fileWriter, subTaskId);
            CompactionMetricsRecorder.recordWriteInfo(this instanceof CrossSpaceCompactionWriter ? CompactionType.CROSS_COMPACTION : CompactionType.INNER_UNSEQ_COMPACTION, ProcessChunkType.DESERIALIZE_CHUNK, this.isAlign, this.chunkWriters[subTaskId].estimateMaxSeriesMemSize());
        }
    }

    protected boolean checkChunkSize(int subTaskId) {
        if (this.chunkWriters[subTaskId] instanceof AlignedChunkWriterImpl) {
            return ((AlignedChunkWriterImpl)this.chunkWriters[subTaskId]).checkIsChunkSizeOverThreshold(this.targetChunkSize);
        }
        return this.chunkWriters[subTaskId].estimateMaxSeriesMemSize() > this.targetChunkSize;
    }

    protected void writeRateLimit(long bytesLength) {
        CompactionTaskManager.mergeRateLimiterAcquire(CompactionTaskManager.getInstance().getMergeWriteRateLimiter(), bytesLength);
    }

    public abstract List<TsFileIOWriter> getFileIOWriter();
}

