/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.consensus.statemachine;

import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.request.ByteBufferConsensusRequest;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.request.MultiLeaderConsensusRequest;
import org.apache.iotdb.db.mpp.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.wal.buffer.WALEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStateMachine
implements IStateMachine,
IStateMachine.EventApi {
    private static final Logger logger = LoggerFactory.getLogger(BaseStateMachine.class);

    protected FragmentInstance getFragmentInstance(IConsensusRequest request) {
        FragmentInstance instance;
        if (request instanceof ByteBufferConsensusRequest) {
            instance = FragmentInstance.deserializeFrom(request.serializeToByteBuffer());
        } else if (request instanceof FragmentInstance) {
            instance = (FragmentInstance)request;
        } else {
            logger.error("Unexpected IConsensusRequest : {}", (Object)request);
            throw new IllegalArgumentException("Unexpected IConsensusRequest!");
        }
        return instance;
    }

    protected PlanNode getPlanNode(IConsensusRequest request) {
        PlanNode node;
        if (request instanceof ByteBufferConsensusRequest) {
            node = PlanNodeType.deserialize(request.serializeToByteBuffer());
        } else if (request instanceof MultiLeaderConsensusRequest) {
            node = WALEntry.deserializeForConsensus(request.serializeToByteBuffer());
        } else if (request instanceof PlanNode) {
            node = (PlanNode)request;
        } else {
            logger.error("Unexpected IConsensusRequest : {}", (Object)request);
            throw new IllegalArgumentException("Unexpected IConsensusRequest!");
        }
        return node;
    }
}

