/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.reader.chunk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.compress.IUnCompressor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.read.reader.page.AlignedPageReader;

public class AlignedChunkReader
implements IChunkReader {
    private final ChunkHeader timeChunkHeader;
    private final List<ChunkHeader> valueChunkHeaderList = new ArrayList<ChunkHeader>();
    private final ByteBuffer timeChunkDataBuffer;
    private final List<ByteBuffer> valueChunkDataBufferList = new ArrayList<ByteBuffer>();
    private final IUnCompressor unCompressor;
    private final Decoder timeDecoder = Decoder.getDecoderByType(TSEncoding.valueOf(TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), TSDataType.INT64);
    private long currentTimestamp;
    protected Filter filter;
    private final List<IPageReader> pageReaderList = new LinkedList<IPageReader>();
    private final List<List<TimeRange>> valueDeleteIntervalList;

    public AlignedChunkReader(Chunk timeChunk, List<Chunk> valueChunkList, Filter filter) throws IOException {
        this.filter = filter;
        this.timeChunkDataBuffer = timeChunk.getData();
        this.valueDeleteIntervalList = new ArrayList<List<TimeRange>>();
        this.timeChunkHeader = timeChunk.getHeader();
        this.unCompressor = IUnCompressor.getUnCompressor(this.timeChunkHeader.getCompressionType());
        this.currentTimestamp = Long.MIN_VALUE;
        ArrayList<Statistics> valueChunkStatisticsList = new ArrayList<Statistics>();
        valueChunkList.forEach(chunk -> {
            this.valueChunkHeaderList.add(chunk == null ? null : chunk.getHeader());
            this.valueChunkDataBufferList.add(chunk == null ? null : chunk.getData());
            valueChunkStatisticsList.add(chunk == null ? null : chunk.getChunkStatistic());
            this.valueDeleteIntervalList.add(chunk == null ? null : chunk.getDeleteIntervalList());
        });
        this.initAllPageReaders(timeChunk.getChunkStatistic(), valueChunkStatisticsList);
    }

    public AlignedChunkReader(Chunk timeChunk, List<Chunk> valueChunkList, Filter filter, long currentTimestamp) throws IOException {
        this.filter = filter;
        this.timeChunkDataBuffer = timeChunk.getData();
        this.valueDeleteIntervalList = new ArrayList<List<TimeRange>>();
        this.timeChunkHeader = timeChunk.getHeader();
        this.unCompressor = IUnCompressor.getUnCompressor(this.timeChunkHeader.getCompressionType());
        this.currentTimestamp = currentTimestamp;
        ArrayList<Statistics> valueChunkStatisticsList = new ArrayList<Statistics>();
        valueChunkList.forEach(chunk -> {
            this.valueChunkHeaderList.add(chunk == null ? null : chunk.getHeader());
            this.valueChunkDataBufferList.add(chunk == null ? null : chunk.getData());
            valueChunkStatisticsList.add(chunk == null ? null : chunk.getChunkStatistic());
            this.valueDeleteIntervalList.add(chunk == null ? null : chunk.getDeleteIntervalList());
        });
        this.initAllPageReaders(timeChunk.getChunkStatistic(), valueChunkStatisticsList);
    }

    private void initAllPageReaders(Statistics timeChunkStatistics, List<Statistics> valueChunkStatisticsList) throws IOException {
        while (this.timeChunkDataBuffer.remaining() > 0) {
            int i;
            PageHeader timePageHeader;
            ArrayList<PageHeader> valuePageHeaderList = new ArrayList<PageHeader>();
            boolean exits = false;
            if ((this.timeChunkHeader.getChunkType() & 0x3F) == 5) {
                timePageHeader = PageHeader.deserializeFrom(this.timeChunkDataBuffer, timeChunkStatistics);
                for (i = 0; i < this.valueChunkDataBufferList.size(); ++i) {
                    if (this.valueChunkDataBufferList.get(i) != null) {
                        exits = true;
                        valuePageHeaderList.add(PageHeader.deserializeFrom(this.valueChunkDataBufferList.get(i), valueChunkStatisticsList.get(i)));
                        continue;
                    }
                    valuePageHeaderList.add(null);
                }
            } else {
                timePageHeader = PageHeader.deserializeFrom(this.timeChunkDataBuffer, this.timeChunkHeader.getDataType());
                for (i = 0; i < this.valueChunkDataBufferList.size(); ++i) {
                    if (this.valueChunkDataBufferList.get(i) != null) {
                        exits = true;
                        valuePageHeaderList.add(PageHeader.deserializeFrom(this.valueChunkDataBufferList.get(i), this.valueChunkHeaderList.get(i).getDataType()));
                        continue;
                    }
                    valuePageHeaderList.add(null);
                }
            }
            if (exits && this.timePageSatisfied(timePageHeader)) {
                AlignedPageReader alignedPageReader = this.constructPageReaderForNextPage(timePageHeader, valuePageHeaderList);
                if (alignedPageReader == null) continue;
                this.pageReaderList.add(alignedPageReader);
                continue;
            }
            this.skipBytesInStreamByLength(timePageHeader, valuePageHeaderList);
        }
    }

    private boolean timePageSatisfied(PageHeader timePageHeader) {
        long startTime = timePageHeader.getStatistics().getStartTime();
        long endTime = timePageHeader.getStatistics().getEndTime();
        return this.filter == null || this.filter.satisfyStartEndTime(startTime, endTime);
    }

    protected boolean pageSatisfied(PageHeader pageHeader, List<TimeRange> valueDeleteInterval) {
        if (this.currentTimestamp > pageHeader.getEndTime()) {
            return false;
        }
        if (valueDeleteInterval != null) {
            for (TimeRange range : valueDeleteInterval) {
                if (range.contains(pageHeader.getStartTime(), pageHeader.getEndTime())) {
                    return false;
                }
                if (!range.overlaps(new TimeRange(pageHeader.getStartTime(), pageHeader.getEndTime()))) continue;
                pageHeader.setModified(true);
            }
        }
        return this.filter == null || this.filter.satisfy(pageHeader.getStatistics());
    }

    private AlignedPageReader constructPageReaderForNextPage(PageHeader timePageHeader, List<PageHeader> valuePageHeader) throws IOException {
        PageInfo timePageInfo = new PageInfo();
        this.getPageInfo(timePageHeader, this.timeChunkDataBuffer, this.timeChunkHeader, timePageInfo);
        PageInfo valuePageInfo = new PageInfo();
        ArrayList<PageHeader> valuePageHeaderList = new ArrayList<PageHeader>();
        ArrayList<ByteBuffer> valuePageDataList = new ArrayList<ByteBuffer>();
        ArrayList<TSDataType> valueDataTypeList = new ArrayList<TSDataType>();
        ArrayList<Decoder> valueDecoderList = new ArrayList<Decoder>();
        boolean exist = false;
        for (int i = 0; i < valuePageHeader.size(); ++i) {
            if (valuePageHeader.get(i) == null || valuePageHeader.get(i).getUncompressedSize() == 0) {
                valuePageHeaderList.add(null);
                valuePageDataList.add(null);
                valueDataTypeList.add(null);
                valueDecoderList.add(null);
                continue;
            }
            if (this.pageSatisfied(valuePageHeader.get(i), this.valueDeleteIntervalList.get(i))) {
                this.getPageInfo(valuePageHeader.get(i), this.valueChunkDataBufferList.get(i), this.valueChunkHeaderList.get(i), valuePageInfo);
                valuePageHeaderList.add(valuePageInfo.pageHeader);
                valuePageDataList.add(valuePageInfo.pageData);
                valueDataTypeList.add(valuePageInfo.dataType);
                valueDecoderList.add(valuePageInfo.decoder);
                exist = true;
                continue;
            }
            this.valueChunkDataBufferList.get(i).position(this.valueChunkDataBufferList.get(i).position() + valuePageHeader.get(i).getCompressedSize());
            valuePageHeaderList.add(null);
            valuePageDataList.add(null);
            valueDataTypeList.add(null);
            valueDecoderList.add(null);
        }
        if (!exist) {
            return null;
        }
        AlignedPageReader alignedPageReader = new AlignedPageReader(timePageHeader, timePageInfo.pageData, this.timeDecoder, valuePageHeaderList, valuePageDataList, valueDataTypeList, valueDecoderList, this.filter);
        alignedPageReader.setDeleteIntervalList(this.valueDeleteIntervalList);
        return alignedPageReader;
    }

    private void getPageInfo(PageHeader pageHeader, ByteBuffer chunkBuffer, ChunkHeader chunkHeader, PageInfo pageInfo) throws IOException {
        pageInfo.pageHeader = pageHeader;
        pageInfo.dataType = chunkHeader.getDataType();
        int compressedPageBodyLength = pageHeader.getCompressedSize();
        byte[] compressedPageBody = new byte[compressedPageBodyLength];
        if (compressedPageBodyLength > chunkBuffer.remaining()) {
            throw new IOException("do not has a complete page body. Expected:" + compressedPageBodyLength + ". Actual:" + chunkBuffer.remaining());
        }
        chunkBuffer.get(compressedPageBody);
        pageInfo.decoder = Decoder.getDecoderByType(chunkHeader.getEncodingType(), chunkHeader.getDataType());
        byte[] uncompressedPageData = new byte[pageHeader.getUncompressedSize()];
        try {
            this.unCompressor.uncompress(compressedPageBody, 0, compressedPageBodyLength, uncompressedPageData, 0);
        }
        catch (Exception e) {
            throw new IOException("Uncompress error! uncompress size: " + pageHeader.getUncompressedSize() + "compressed size: " + pageHeader.getCompressedSize() + "page header: " + pageHeader + e.getMessage());
        }
        pageInfo.pageData = ByteBuffer.wrap(uncompressedPageData);
    }

    private void skipBytesInStreamByLength(PageHeader timePageHeader, List<PageHeader> valuePageHeader) {
        this.timeChunkDataBuffer.position(this.timeChunkDataBuffer.position() + timePageHeader.getCompressedSize());
        for (int i = 0; i < valuePageHeader.size(); ++i) {
            if (valuePageHeader.get(i) == null) continue;
            this.valueChunkDataBufferList.get(i).position(this.valueChunkDataBufferList.get(i).position() + valuePageHeader.get(i).getCompressedSize());
        }
    }

    @Override
    public boolean hasNextSatisfiedPage() {
        return !this.pageReaderList.isEmpty();
    }

    @Override
    public BatchData nextPageData() throws IOException {
        if (this.pageReaderList.isEmpty()) {
            throw new IOException("No more page");
        }
        return this.pageReaderList.remove(0).getAllSatisfiedPageData();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public List<IPageReader> loadPageReaderList() {
        return this.pageReaderList;
    }

    private static class PageInfo {
        PageHeader pageHeader;
        ByteBuffer pageData;
        TSDataType dataType;
        Decoder decoder;

        private PageInfo() {
        }
    }
}

