/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.db.qp.utils.DatetimeUtils;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.SessionDataSet;
import org.apache.iotdb.tool.AbstractCsvTool;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.thrift.annotation.Nullable;

public class ImportCsv
extends AbstractCsvTool {
    private static final String FILE_ARGS = "f";
    private static final String FILE_NAME = "file or folder";
    private static final String FAILED_FILE_ARGS = "fd";
    private static final String FAILED_FILE_NAME = "failed file directory";
    private static final String BATCH_POINT_SIZE_ARGS = "batch";
    private static final String BATCH_POINT_SIZE_NAME = "batch point size";
    private static final String ALIGNED_ARGS = "aligned";
    private static final String ALIGNED_NAME = "use the aligned interface";
    private static final String CSV_SUFFIXS = "csv";
    private static final String TXT_SUFFIXS = "txt";
    private static final String TIMESTAMP_PRECISION_ARGS = "tp";
    private static final String TIMESTAMP_PRECISION_NAME = "timestamp precision (ms/us/ns)";
    private static final String TYPE_INFER_ARGS = "typeInfer";
    private static final String TYPE_INFER_ARGS_NAME = "type infer";
    private static final String LINES_PER_FAILED_FILE_ARGS = "linesPerFailedFile";
    private static final String LINES_PER_FAILED_FILE_ARGS_NAME = "Lines Per FailedFile";
    private static final String TSFILEDB_CLI_PREFIX = "ImportCsv";
    private static String targetPath;
    private static String failedFileDirectory;
    private static int linesPerFailedFile;
    private static Boolean aligned;
    private static String timeColumn;
    private static String deviceColumn;
    private static int batchPointSize;
    private static String timestampPrecision;
    private static final Map<String, TSDataType> TYPE_INFER_KEY_DICT;
    private static final Map<String, TSDataType> TYPE_INFER_VALUE_DICT;

    private static Options createOptions() {
        Options options = ImportCsv.createNewOptions();
        Option opFile = Option.builder((String)FILE_ARGS).required().argName(FILE_NAME).hasArg().desc("If input a file path, load a csv file, otherwise load all csv file under this directory (required)").build();
        options.addOption(opFile);
        Option opFailedFile = Option.builder((String)FAILED_FILE_ARGS).argName(FAILED_FILE_NAME).hasArg().desc("Specifying a directory to save failed file, default YOUR_CSV_FILE_PATH (optional)").build();
        options.addOption(opFailedFile);
        Option opAligned = Option.builder((String)ALIGNED_ARGS).argName(ALIGNED_NAME).hasArg().desc("Whether to use the interface of aligned (optional)").build();
        options.addOption(opAligned);
        Option opHelp = Option.builder((String)"help").longOpt("help").hasArg(false).desc("Display help information").build();
        options.addOption(opHelp);
        Option opTimeZone = Option.builder((String)"tz").argName("timeZone").hasArg().desc("Time Zone eg. +08:00 or -01:00 (optional)").build();
        options.addOption(opTimeZone);
        Option opBatchPointSize = Option.builder((String)BATCH_POINT_SIZE_ARGS).argName(BATCH_POINT_SIZE_NAME).hasArg().desc("100000 (optional)").build();
        options.addOption(opBatchPointSize);
        Option opTimestampPrecision = Option.builder((String)TIMESTAMP_PRECISION_ARGS).argName(TIMESTAMP_PRECISION_NAME).hasArg().desc("Timestamp precision (ms/us/ns)").build();
        options.addOption(opTimestampPrecision);
        Option opTypeInfer = Option.builder((String)TYPE_INFER_ARGS).argName(TYPE_INFER_ARGS_NAME).numberOfArgs(5).hasArgs().valueSeparator(',').desc("Define type info by option:\"boolean=text,int=long, ...").build();
        options.addOption(opTypeInfer);
        Option opFailedLinesPerFile = Option.builder((String)LINES_PER_FAILED_FILE_ARGS).argName(LINES_PER_FAILED_FILE_ARGS_NAME).hasArgs().desc("Lines per failedfile").build();
        options.addOption(opFailedLinesPerFile);
        return options;
    }

    private static void parseSpecialParams(CommandLine commandLine) throws ArgsErrorException {
        String[] opTypeInferValues;
        File file;
        timeZoneID = commandLine.getOptionValue("tz");
        targetPath = commandLine.getOptionValue(FILE_ARGS);
        if (commandLine.getOptionValue(BATCH_POINT_SIZE_ARGS) != null) {
            batchPointSize = Integer.parseInt(commandLine.getOptionValue(BATCH_POINT_SIZE_ARGS));
        }
        if (commandLine.getOptionValue(FAILED_FILE_ARGS) != null && !(file = new File(failedFileDirectory = commandLine.getOptionValue(FAILED_FILE_ARGS))).isDirectory()) {
            file.mkdir();
            failedFileDirectory = file.getAbsolutePath() + File.separator;
        }
        if (commandLine.getOptionValue(ALIGNED_ARGS) != null) {
            aligned = Boolean.valueOf(commandLine.getOptionValue(ALIGNED_ARGS));
        }
        if (commandLine.getOptionValue(TIMESTAMP_PRECISION_ARGS) != null) {
            timestampPrecision = commandLine.getOptionValue(TIMESTAMP_PRECISION_ARGS);
        }
        if ((opTypeInferValues = commandLine.getOptionValues(TYPE_INFER_ARGS)) != null && opTypeInferValues.length > 0) {
            for (String opTypeInferValue : opTypeInferValues) {
                if (!opTypeInferValue.contains("=")) continue;
                String[] typeInfoExpressionArr = opTypeInferValue.split("=");
                String key = typeInfoExpressionArr[0];
                String value = typeInfoExpressionArr[1];
                ImportCsv.applyTypeInferArgs(key, value);
            }
        }
        if (commandLine.getOptionValue(LINES_PER_FAILED_FILE_ARGS) != null) {
            linesPerFailedFile = Integer.parseInt(commandLine.getOptionValue(LINES_PER_FAILED_FILE_ARGS));
        }
    }

    private static void applyTypeInferArgs(String key, String value) throws ArgsErrorException {
        if (!TYPE_INFER_KEY_DICT.containsKey(key)) {
            throw new ArgsErrorException("Unknown type infer key: " + key);
        }
        if (!TYPE_INFER_VALUE_DICT.containsKey(value)) {
            throw new ArgsErrorException("Unknown type infer value: " + value);
        }
        if (key.equals("NaN") && !value.equals("float") && !value.equals("double") && !value.equals("text")) {
            throw new ArgsErrorException("NaN can not convert to " + value);
        }
        if (key.equals("boolean") && !value.equals("boolean") && !value.equals("text")) {
            throw new ArgsErrorException("Boolean can not convert to " + value);
        }
        TSDataType srcType = TYPE_INFER_VALUE_DICT.get(key);
        TSDataType dstType = TYPE_INFER_VALUE_DICT.get(value);
        if (dstType.getType() < srcType.getType()) {
            throw new ArgsErrorException(key + " can not convert to " + value);
        }
        TYPE_INFER_KEY_DICT.put(key, TYPE_INFER_VALUE_DICT.get(value));
    }

    public static void main(String[] args) throws IoTDBConnectionException {
        Options options = ImportCsv.createOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setOptionComparator(null);
        hf.setWidth(92);
        CommandLine commandLine = null;
        DefaultParser parser = new DefaultParser();
        if (args == null || args.length == 0) {
            System.out.println("Too few params input, please check the following hint.");
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            System.exit(1);
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.out.println("Parse error: " + e.getMessage());
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            System.exit(1);
        }
        if (commandLine.hasOption("help")) {
            hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
            System.exit(1);
        }
        try {
            ImportCsv.parseBasicParams(commandLine);
            String filename = commandLine.getOptionValue(FILE_ARGS);
            if (filename == null) {
                hf.printHelp(TSFILEDB_CLI_PREFIX, options, true);
                System.exit(1);
            }
            ImportCsv.parseSpecialParams(commandLine);
        }
        catch (ArgsErrorException e) {
            System.out.println("Args error: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.out.println("Encounter an error, because: " + e.getMessage());
            System.exit(1);
        }
        System.exit(ImportCsv.importFromTargetPath(host, Integer.parseInt(port), username, password, targetPath, timeZoneID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int importFromTargetPath(String host, int port, String username, String password, String targetPath, String timeZone) throws IoTDBConnectionException {
        block11: {
            try {
                session = new Session(host, port, username, password, false);
                session.open(false);
                timeZoneID = timeZone;
                ImportCsv.setTimeZone();
                File file = new File(targetPath);
                if (file.isFile()) {
                    ImportCsv.importFromSingleFile(file);
                    break block11;
                }
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    if (files == null) {
                        int n = 0;
                        return n;
                    }
                    for (File subFile : files) {
                        if (!subFile.isFile()) continue;
                        ImportCsv.importFromSingleFile(subFile);
                    }
                    break block11;
                }
                System.out.println("File not found!");
                int n = 1;
                return n;
            }
            catch (IoTDBConnectionException | StatementExecutionException e) {
                System.out.println("Encounter an error when connecting to server, because " + e.getMessage());
                int n = 1;
                return n;
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        return 0;
    }

    private static void importFromSingleFile(File file) {
        block7: {
            if (file.getName().endsWith(CSV_SUFFIXS) || file.getName().endsWith(TXT_SUFFIXS)) {
                try {
                    CSVParser csvRecords = ImportCsv.readCsvFile(file.getAbsolutePath());
                    List headerNames = csvRecords.getHeaderNames();
                    Stream records = csvRecords.stream();
                    if (headerNames.isEmpty()) {
                        System.out.println("Empty file!");
                        return;
                    }
                    if (!timeColumn.equalsIgnoreCase((String)headerNames.get(0))) {
                        System.out.println("No headers!");
                        return;
                    }
                    String failedFilePath = null;
                    failedFilePath = failedFileDirectory == null ? file.getAbsolutePath() + ".failed" : failedFileDirectory + file.getName() + ".failed";
                    if (!deviceColumn.equalsIgnoreCase((String)headerNames.get(1))) {
                        ImportCsv.writeDataAlignedByTime(headerNames, records, failedFilePath);
                        break block7;
                    }
                    ImportCsv.writeDataAlignedByDevice(headerNames, records, failedFilePath);
                }
                catch (IOException e) {
                    System.out.println("CSV file read exception because: " + e.getMessage());
                }
            } else {
                System.out.println("The file name must end with \"csv\" or \"txt\"!");
            }
        }
    }

    private static void writeDataAlignedByTime(List<String> headerNames, Stream<CSVRecord> records, String failedFilePath) {
        HashMap<String, List<String>> deviceAndMeasurementNames = new HashMap<String, List<String>>();
        HashMap<String, TSDataType> headerTypeMap = new HashMap<String, TSDataType>();
        HashMap<String, String> headerNameMap = new HashMap<String, String>();
        ImportCsv.parseHeaders(headerNames, deviceAndMeasurementNames, headerTypeMap, headerNameMap);
        Set<String> devices = deviceAndMeasurementNames.keySet();
        String devicesStr = StringUtils.join(devices, (String)",");
        if (headerTypeMap.isEmpty()) {
            try {
                ImportCsv.queryType(devicesStr, headerTypeMap, "Time");
            }
            catch (IoTDBConnectionException e) {
                e.printStackTrace();
            }
        }
        ArrayList<String> deviceIds = new ArrayList<String>();
        ArrayList<Long> times = new ArrayList<Long>();
        ArrayList<List<String>> measurementsList = new ArrayList<List<String>>();
        ArrayList<List<TSDataType>> typesList = new ArrayList<List<TSDataType>>();
        ArrayList<List<Object>> valuesList = new ArrayList<List<Object>>();
        AtomicReference<Boolean> hasStarted = new AtomicReference<Boolean>(false);
        AtomicInteger pointSize = new AtomicInteger(0);
        ArrayList<List<Object>> failedRecords = new ArrayList<List<Object>>();
        records.forEach(record -> {
            if (!((Boolean)hasStarted.get()).booleanValue()) {
                hasStarted.set(true);
            } else if (pointSize.get() >= batchPointSize) {
                ImportCsv.writeAndEmptyDataSet(deviceIds, (List<Long>)times, (List<List<TSDataType>>)typesList, (List<List<Object>>)valuesList, (List<List<String>>)measurementsList, 3);
                pointSize.set(0);
            }
            boolean isFail = false;
            for (String deviceId : deviceAndMeasurementNames.keySet()) {
                ArrayList<TSDataType> types = new ArrayList<TSDataType>();
                ArrayList<Object> values = new ArrayList<Object>();
                ArrayList<String> measurements = new ArrayList<String>();
                List measurementNames = (List)deviceAndMeasurementNames.get(deviceId);
                for (String measurement : measurementNames) {
                    TSDataType type;
                    String header = deviceId + "." + measurement;
                    String value = record.get(header);
                    if ("".equals(value)) continue;
                    if (!headerTypeMap.containsKey(headerNameMap.get(header))) {
                        type = ImportCsv.typeInfer(value);
                        if (type != null) {
                            headerTypeMap.put(header, type);
                        } else {
                            System.out.printf("Line '%s', column '%s': '%s' unknown type%n", record.getRecordNumber(), header, value);
                            isFail = true;
                        }
                    }
                    if ((type = (TSDataType)headerTypeMap.get(headerNameMap.get(header))) == null) continue;
                    Object valueTrans = ImportCsv.typeTrans(value, type);
                    if (valueTrans == null) {
                        isFail = true;
                        System.out.printf("Line '%s', column '%s': '%s' can't convert to '%s'%n", record.getRecordNumber(), header, value, type);
                        continue;
                    }
                    measurements.add(((String)headerNameMap.get(header)).replace(deviceId + '.', ""));
                    types.add(type);
                    values.add(valueTrans);
                    pointSize.getAndIncrement();
                }
                if (measurements.isEmpty()) continue;
                times.add(ImportCsv.parseTimestamp(record.get(timeColumn)));
                deviceIds.add(deviceId);
                typesList.add(types);
                valuesList.add(values);
                measurementsList.add(measurements);
            }
            if (isFail) {
                failedRecords.add(record.stream().collect(Collectors.toList()));
            }
        });
        if (!deviceIds.isEmpty()) {
            ImportCsv.writeAndEmptyDataSet(deviceIds, times, typesList, valuesList, measurementsList, 3);
            pointSize.set(0);
        }
        if (!failedRecords.isEmpty()) {
            ImportCsv.writeFailedLinesFile(headerNames, failedFilePath, failedRecords);
        }
        if (hasStarted.get().booleanValue()) {
            System.out.println("Import completely!");
        } else {
            System.out.println("No records!");
        }
    }

    private static void writeDataAlignedByDevice(List<String> headerNames, Stream<CSVRecord> records, String failedFilePath) {
        HashMap<String, TSDataType> headerTypeMap = new HashMap<String, TSDataType>();
        HashMap<String, String> headerNameMap = new HashMap<String, String>();
        ImportCsv.parseHeaders(headerNames, null, headerTypeMap, headerNameMap);
        AtomicReference<Object> deviceName = new AtomicReference<Object>(null);
        HashSet typeQueriedDevice = new HashSet();
        ArrayList<Long> times = new ArrayList<Long>();
        ArrayList<List<TSDataType>> typesList = new ArrayList<List<TSDataType>>();
        ArrayList<List<Object>> valuesList = new ArrayList<List<Object>>();
        ArrayList<List<String>> measurementsList = new ArrayList<List<String>>();
        AtomicInteger pointSize = new AtomicInteger(0);
        ArrayList<List<Object>> failedRecords = new ArrayList<List<Object>>();
        records.forEach(record -> {
            if (deviceName.get() == null) {
                deviceName.set(record.get(1));
            } else if (!Objects.equals(deviceName.get(), record.get(1))) {
                ImportCsv.writeAndEmptyDataSet((String)deviceName.get(), (List<Long>)times, (List<List<TSDataType>>)typesList, (List<List<Object>>)valuesList, (List<List<String>>)measurementsList, 3);
                deviceName.set(record.get(1));
                pointSize.set(0);
            } else if (pointSize.get() >= batchPointSize) {
                ImportCsv.writeAndEmptyDataSet((String)deviceName.get(), (List<Long>)times, (List<List<TSDataType>>)typesList, (List<List<Object>>)valuesList, (List<List<String>>)measurementsList, 3);
                pointSize.set(0);
            }
            ArrayList<TSDataType> types = new ArrayList<TSDataType>();
            ArrayList<Object> values = new ArrayList<Object>();
            ArrayList<String> measurements = new ArrayList<String>();
            AtomicReference<Boolean> isFail = new AtomicReference<Boolean>(false);
            for (String measurement : headerNameMap.keySet()) {
                TSDataType type;
                String value = record.get(measurement);
                if ("".equals(value)) continue;
                if (!headerTypeMap.containsKey(headerNameMap.get(measurement))) {
                    boolean hasResult = false;
                    if (!typeQueriedDevice.contains(deviceName.get())) {
                        try {
                            if (headerTypeMap.isEmpty()) {
                                hasResult = ImportCsv.queryType((String)deviceName.get(), headerTypeMap, "Device");
                            }
                            typeQueriedDevice.add((String)deviceName.get());
                        }
                        catch (IoTDBConnectionException e) {
                            e.printStackTrace();
                        }
                    }
                    if (!hasResult) {
                        type = ImportCsv.typeInfer(value);
                        if (type != null) {
                            headerTypeMap.put(measurement, type);
                        } else {
                            System.out.printf("Line '%s', column '%s': '%s' unknown type%n", record.getRecordNumber(), measurement, value);
                            isFail.set(true);
                        }
                    }
                }
                if ((type = (TSDataType)headerTypeMap.get(headerNameMap.get(measurement))) == null) continue;
                Object valueTrans = ImportCsv.typeTrans(value, type);
                if (valueTrans == null) {
                    isFail.set(true);
                    System.out.printf("Line '%s', column '%s': '%s' can't convert to '%s'%n", record.getRecordNumber(), headerNameMap.get(measurement), value, type);
                    continue;
                }
                values.add(valueTrans);
                measurements.add((String)headerNameMap.get(measurement));
                types.add(type);
                pointSize.getAndIncrement();
            }
            if (isFail.get().booleanValue()) {
                failedRecords.add(record.stream().collect(Collectors.toList()));
            }
            if (!measurements.isEmpty()) {
                times.add(ImportCsv.parseTimestamp(record.get(timeColumn)));
                typesList.add(types);
                valuesList.add(values);
                measurementsList.add(measurements);
            }
        });
        if (times.size() != 0) {
            ImportCsv.writeAndEmptyDataSet(deviceName.get(), times, typesList, valuesList, measurementsList, 3);
            pointSize.set(0);
        }
        if (!failedRecords.isEmpty()) {
            ImportCsv.writeFailedLinesFile(headerNames, failedFilePath, failedRecords);
        }
        System.out.println("Import completely!");
    }

    private static void writeFailedLinesFile(List<String> headerNames, String failedFilePath, ArrayList<List<Object>> failedRecords) {
        int failedRecordsSize;
        int fileIndex = 0;
        int from = 0;
        int restFailedRecords = failedRecordsSize = failedRecords.size();
        while (from < failedRecordsSize) {
            int step = Math.min(restFailedRecords, linesPerFailedFile);
            ImportCsv.writeCsvFile(headerNames, failedRecords.subList(from, from + step), failedFilePath + "_" + fileIndex++);
            from += step;
            restFailedRecords -= step;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndEmptyDataSet(String device, List<Long> times, List<List<TSDataType>> typesList, List<List<Object>> valuesList, List<List<String>> measurementsList, int retryTime) {
        block11: {
            try {
                if (!aligned.booleanValue()) {
                    session.insertRecordsOfOneDevice(device, times, measurementsList, typesList, valuesList);
                } else {
                    session.insertAlignedRecordsOfOneDevice(device, times, measurementsList, typesList, valuesList);
                }
            }
            catch (IoTDBConnectionException e) {
                if (retryTime <= 0) break block11;
                try {
                    session.open();
                }
                catch (IoTDBConnectionException ex) {
                    System.out.println("Meet error when insert csv because " + e.getMessage());
                }
                ImportCsv.writeAndEmptyDataSet(device, times, typesList, valuesList, measurementsList, --retryTime);
            }
            catch (StatementExecutionException e) {
                System.out.println("Meet error when insert csv because " + e.getMessage());
            }
            finally {
                times.clear();
                typesList.clear();
                valuesList.clear();
                measurementsList.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndEmptyDataSet(List<String> deviceIds, List<Long> times, List<List<TSDataType>> typesList, List<List<Object>> valuesList, List<List<String>> measurementsList, int retryTime) {
        block11: {
            try {
                if (!aligned.booleanValue()) {
                    session.insertRecords(deviceIds, times, measurementsList, typesList, valuesList);
                } else {
                    session.insertAlignedRecords(deviceIds, times, measurementsList, typesList, valuesList);
                }
            }
            catch (IoTDBConnectionException e) {
                if (retryTime <= 0) break block11;
                try {
                    session.open();
                }
                catch (IoTDBConnectionException ex) {
                    System.out.println("Meet error when insert csv because " + e.getMessage());
                }
                ImportCsv.writeAndEmptyDataSet(deviceIds, times, typesList, valuesList, measurementsList, --retryTime);
            }
            catch (StatementExecutionException e) {
                System.out.println("Meet error when insert csv because " + e.getMessage());
            }
            finally {
                deviceIds.clear();
                times.clear();
                typesList.clear();
                valuesList.clear();
                measurementsList.clear();
            }
        }
    }

    private static CSVParser readCsvFile(String path) throws IOException {
        return CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setHeader(new String[0]).setSkipHeaderRecord(true).setQuote('`').setEscape('\\').setIgnoreEmptyLines(true).build().parse((Reader)new InputStreamReader(new FileInputStream(path)));
    }

    private static void parseHeaders(List<String> headerNames, @Nullable HashMap<String, List<String>> deviceAndMeasurementNames, HashMap<String, TSDataType> headerTypeMap, HashMap<String, String> headerNameMap) {
        String regex = "(?<=\\()\\S+(?=\\))";
        Pattern pattern = Pattern.compile(regex);
        for (String headerName : headerNames) {
            if ("Time".equalsIgnoreCase(headerName)) {
                timeColumn = headerName;
                continue;
            }
            if ("Device".equalsIgnoreCase(headerName)) {
                deviceColumn = headerName;
                continue;
            }
            Matcher matcher = pattern.matcher(headerName);
            if (matcher.find()) {
                String type = matcher.group();
                String headerNameWithoutType = headerName.replace("(" + type + ")", "").replaceAll("\\s+", "");
                headerNameMap.put(headerName, headerNameWithoutType);
                headerTypeMap.put(headerNameWithoutType, ImportCsv.getType(type));
            } else {
                headerNameMap.put(headerName, headerName);
            }
            String[] split = headerName.split("\\.");
            String measurementName = split[split.length - 1];
            String deviceName = StringUtils.join((Object[])Arrays.copyOfRange(split, 0, split.length - 1), (char)'.');
            if (deviceAndMeasurementNames == null) continue;
            if (!deviceAndMeasurementNames.containsKey(deviceName)) {
                deviceAndMeasurementNames.put(deviceName, new ArrayList());
            }
            deviceAndMeasurementNames.get(deviceName).add(measurementName);
        }
    }

    private static boolean queryType(String deviceNames, HashMap<String, TSDataType> headerTypeMap, String alignedType) throws IoTDBConnectionException {
        String sql = "select * from " + deviceNames + " limit 1";
        SessionDataSet sessionDataSet = null;
        try {
            sessionDataSet = session.executeQueryStatement(sql);
        }
        catch (StatementExecutionException e) {
            System.out.println("Meet error when query the type of timeseries because " + e.getMessage());
            return false;
        }
        List columnNames = sessionDataSet.getColumnNames();
        List columnTypes = sessionDataSet.getColumnTypes();
        if (columnNames.size() == 1) {
            return false;
        }
        for (int i = 1; i < columnNames.size(); ++i) {
            if (Objects.equals(alignedType, "Time")) {
                headerTypeMap.put((String)columnNames.get(i), ImportCsv.getType((String)columnTypes.get(i)));
                continue;
            }
            if (!Objects.equals(alignedType, "Device")) continue;
            String[] split = ((String)columnNames.get(i)).split("\\.");
            String measurement = split[split.length - 1];
            headerTypeMap.put(measurement, ImportCsv.getType((String)columnTypes.get(i)));
        }
        return true;
    }

    private static TSDataType getType(String typeStr) {
        switch (typeStr) {
            case "TEXT": {
                return TSDataType.TEXT;
            }
            case "BOOLEAN": {
                return TSDataType.BOOLEAN;
            }
            case "INT32": {
                return TSDataType.INT32;
            }
            case "INT64": {
                return TSDataType.INT64;
            }
            case "FLOAT": {
                return TSDataType.FLOAT;
            }
            case "DOUBLE": {
                return TSDataType.DOUBLE;
            }
        }
        return null;
    }

    private static TSDataType typeInfer(String strValue) {
        if (strValue.contains("\"")) {
            return TSDataType.TEXT;
        }
        if (ImportCsv.isBoolean(strValue)) {
            return TYPE_INFER_KEY_DICT.get("boolean");
        }
        if (ImportCsv.isNumber(strValue)) {
            if (!strValue.contains(".")) {
                if (ImportCsv.isConvertFloatPrecisionLack(StringUtils.trim((String)strValue))) {
                    return TYPE_INFER_KEY_DICT.get("long");
                }
                return TYPE_INFER_KEY_DICT.get("int");
            }
            return TYPE_INFER_KEY_DICT.get("float");
        }
        if ("null".equals(strValue) || "NULL".equals(strValue)) {
            return null;
        }
        if ("NaN".equals(strValue)) {
            return TYPE_INFER_KEY_DICT.get("NaN");
        }
        return TSDataType.TEXT;
    }

    static boolean isNumber(String s) {
        if (s == null || s.equals("NaN")) {
            return false;
        }
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean isBoolean(String s) {
        return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false");
    }

    private static boolean isConvertFloatPrecisionLack(String s) {
        return Long.parseLong(s) > 0x2000000L;
    }

    private static Object typeTrans(String value, TSDataType type) {
        try {
            switch (type) {
                case TEXT: {
                    if (value.startsWith("\"") && value.endsWith("\"")) {
                        return value.substring(1, value.length() - 1);
                    }
                    return value;
                }
                case BOOLEAN: {
                    if (!"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) {
                        return null;
                    }
                    return Boolean.parseBoolean(value);
                }
                case INT32: {
                    return Integer.parseInt(value);
                }
                case INT64: {
                    return Long.parseLong(value);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case DOUBLE: {
                    return Double.parseDouble(value);
                }
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static long parseTimestamp(String str) {
        long timestamp;
        try {
            timestamp = Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            timestamp = DatetimeUtils.convertDatetimeStrToLong(str, zoneId, timestampPrecision);
        }
        return timestamp;
    }

    static {
        failedFileDirectory = null;
        linesPerFailedFile = 10000;
        aligned = false;
        timeColumn = "Time";
        deviceColumn = "Device";
        batchPointSize = 100000;
        timestampPrecision = "ms";
        TYPE_INFER_KEY_DICT = new HashMap<String, TSDataType>();
        TYPE_INFER_KEY_DICT.put("boolean", TSDataType.BOOLEAN);
        TYPE_INFER_KEY_DICT.put("int", TSDataType.FLOAT);
        TYPE_INFER_KEY_DICT.put("long", TSDataType.DOUBLE);
        TYPE_INFER_KEY_DICT.put("float", TSDataType.FLOAT);
        TYPE_INFER_KEY_DICT.put("double", TSDataType.DOUBLE);
        TYPE_INFER_KEY_DICT.put("NaN", TSDataType.DOUBLE);
        TYPE_INFER_VALUE_DICT = new HashMap<String, TSDataType>();
        TYPE_INFER_VALUE_DICT.put("boolean", TSDataType.BOOLEAN);
        TYPE_INFER_VALUE_DICT.put("int", TSDataType.INT32);
        TYPE_INFER_VALUE_DICT.put("long", TSDataType.INT64);
        TYPE_INFER_VALUE_DICT.put("float", TSDataType.FLOAT);
        TYPE_INFER_VALUE_DICT.put("double", TSDataType.DOUBLE);
        TYPE_INFER_VALUE_DICT.put("text", TSDataType.TEXT);
    }
}

