<!--

    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.

-->
## How the Community Works
The following content refers to the "Apache Way". For more details, you can see the official website for Apache Software Foundation. https://www.apache.org/
### 1.Roles
Individuals or groups that have the common purpose to advance Apache IoTDB, identify with the open-source culture and abide by relevant norms come together to form our community.
With reference to Apache's community concept, our community has the following roles.
#### 1.1 User
A user is someone who uses our software. They contribute to Apache IoTDB by providing feedback to developers in the form of bug reports and feature suggestions. Users participate in the community by helping other users on mailing lists and user support forums.
#### 1.2 Contributor
A contributor is a user who contributes to Apache IoTDB in the form of code or documentation. They take extra steps to participate in Apache IoTDB, are active on the developer mailing list, participate in discussions, and provide patches, documentation, suggestions, and criticism. Contributors are also known as developers.
#### 1.3 Committer
A committer is a developer who has write access to the code repository and has a signed Contributor License Agreement (CLA) on file. They have an apache.org mail address. Not needing to depend on other people to make patches to the code or documentation, they are actually making short-term decisions for the project. The PMC can (even tacitly) agree and approve the changes into permanency, or they can reject them. Remember that the PMC makes the decisions, not the individual committers.
#### 1.4 PMC Member
A PMC member is a committer who was elected due to merit for the evolution of the project. They have write access to the code repository, an apache.org mail address, the right to vote on community-related decisions and the right to propose other active contributors for committership. The PMC as a whole is the entity that controls the project, nobody else. In particular, the PMC must vote to approve any formal release of their project's software products.

### 2.How to Become A Committer or PMC Member
#### 2.1 To Be A Committer
A professional will be promoted as an Apache Committer, only if he/she has gained the trust and recommendation of the PMC, that whatever changes you push inside the project, that will not affect the overall functionality of the project and hence establish a sufficient understanding of the project and its requirements. 
To become a committer, you need to have a full understanding of a functional module or play a substantial role in promoting the project, such as writing technical documents, providing user cases, actively participating in community events, etc.
#### 2.2 To Be A PMC Member
A project management committee (PMC) is a committee of the Apache Software Foundation charged with responsibility and governance for their top level project. The PMC is the vehicle through which decision-making power and responsibility for oversight devolves to developers.
Recommendation from a PMC member is also required. You need to have a comprehensive understanding of the project, a deep insight into the time series database industry and a strong sense of identity with the open-source culture and contribute to promoting the project

### 3.Communication
Communication plays an important role in our community. There are some ways to communicate.
#### 1.Communicate via Apache mailing lists
Apache projects use mailing lists to coordinate development of their software and administer their organization. Mailing lists also serve as a primary support channel where users can help each other learn to use the software.
To subscribe the developer mailing list, send an email to dev-subscribe@iotdb.apache.org. The subject and content are not limited. After sending the first email, you receive a "confirm subscription" email from an address ended by "iotdb.apache.org.". Send another email with unlimited subject and content to this mailbox to confirm the subscription.
#### 2.Communicate on Slack
Join our Slack Channel for communication. https://apacheiotdb.slack.com/ssb/redirect
#### 3.Communicate on Jira
We use Jira for task management and communication.
To join our team in Jira, create a Jira account, which is for task management and a Confluence account, which is for co-construction of design documents. Once the accounts are created, send an email to the mailing list, including self-introduction, Jira id and Confluence id. The PMC members will add permissions to your account.
#### 4.Communicate on GitHub

### 4.Code of Conduct
The following convention is established in line with the community culture of Apache.
1. Be open. We invite anyone to participate in our community. We prefer to use public methods of communication for project-related messages, unless discussing something sensitive. This applies to messages for help or project-related support, too; not only is a public support request much more likely to result in an answer to a question, it also makes sure that any the community notices and corrects any inadvertent mistakes people answering the query may make.
2. Be empathetic, welcoming, friendly, and patient. We work together to resolve conflicts, assume good intentions, and do our best to act in an empathetic fashion. We may all experience some frustration from time to time, but we do not allow frustration to result in a personal attack. A community where people feel uncomfortable or threatened is not a productive one. We should be respectful when dealing with other community members as well as with people outside our community.
3. Be collaborative. Other people will use our work, and we in turn depend on the work of others. When we make something for the benefit of the project, we are willing to explain to others how it works, so they can build on the work to make it even better. Any decision we make will affect users and colleagues, and we take those consequences seriously when making decisions.
4. Be inquisitive. Nobody knows everything! Asking questions early avoids many problems later, so we encourage questions, although we may redirect them to the appropriate forum. Those who receive a question should be responsive and helpful, within the context of our shared goal of improving Apache project code.
5. Be careful in the words that we choose. Whether we are participating as professionals or volunteers, we value professionalism in all interactions, and take responsibility for our own speech. Be kind to others. Do not insult or put down other participants. Harassment and other exclusionary behaviour are not acceptable. This includes, but is not limited to:
* Violent threats or language directed against another person.
* Sexist, racist, or otherwise discriminatory jokes and language.
* Posting sexually explicit or violent material.
* Posting (or threatening to post) other people's personally identifying information ("doxing").
* Sharing private content, such as emails sent privately or non-publicly, or from unlogged forums such as IRC channel history.
* Personal insults, especially those using racist or sexist terms.
* Unwelcome sexual attention.
* Excessive or unnecessary profanity.
* Repeated harassment of others. In general, if someone asks you to stop, then stop.
* Advocating for, or encouraging, any of the above behaviour.

6. Be concise. Keep in mind that, over time, hundreds or thousands of people will read what you write. Writing a short email means people can understand the conversation as efficiently as possible. Short emails should always strive to be empathetic, welcoming, friendly and patient. When a long explanation is necessary, consider adding a summary at the top of the message.
Try to bring new ideas to a conversation so that each email adds something unique to the thread, keeping in mind that the rest of the thread still contains the other messages with arguments that have already been made.
Try to stay on topic, especially in discussions that are already fairly long.
7. Step down considerately. Members of every project come and go. When somebody leaves or disengages from the project they should tell people they are leaving and take the proper steps to ensure that others can pick up where they left off. In doing so, they should remain respectful of those who continue to participate in the project and should not misrepresent the project's goals or achievements. Likewise, community members should respect any individual's choice to leave the project.
### 5.Release Creation
#### 5.1 The release manager
Our project designates a committer to be the release manager who takes responsibility for the mechanics of a release. Release managers shepherd a release from an initial community consensus to getting the compiled code package to final distribution, and may be involved in publicizing the release to the project's community and the ASF in general.
#### 5.2 Process
Generally, it takes five steps to release a new version.
Step 1: RM initiates a proposal. RM sends out the proposal by email. The proposal should fully explain the improvements to the new version.
Step 2: Community developers view the proposal. After receiving an email, if developers have any suggestions or doubts ,then reply to the email.
Step 3: RM releases a Release Candidate. After the opinions from community developers are fully considered, RM (Release Manager) releases a Release Candidate via email for the developers to test and vote.
Step 4: Community developers vote. Community developers receive the Release Candidate and test it. Then, vote by email.
Step 5: After the Release Candidate is voted through, RM releases an official version and makes an announcement. When the voting results meet the prescribed situation, RM releases an official version and announces the news by email. (If the Release Candidate fails, RM announces the failure of the new release by email. The process can be restarted after modification. ）

#### 5.3 How to Test the Release Candidate
https://iotdb.apache.org/Development/VoteRelease.html
#### 5.4 Vote Template
The notation used in voting is:
- +1 Yes, I agree
- 0 I have no strong opinion
- -1 I object on the following grounds
If you object you must support your objection and provide an alternative course of action that you are willing and able to implement (where appropriate).
#### 5.5 Decision Making
According to the instructions given by Apache Software Foundation, we will keep the voting window for at least 72h. When at least three PMC members vote for the proposal and there are more "yes" than "no", the proposal is passed. The results of the voting will be summarized by RM (Release Manager). RM publishes the results via email.
#### 5.6 How to Release
A detailed guide for a new RM is provided. Please check out the blog "How to Release".