/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.service;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.udf.service.SnapshotUtils;
import org.apache.iotdb.commons.udf.service.UDFExecutableResource;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;

public class UDFExecutableManager
implements IService,
SnapshotProcessor {
    private final String temporaryLibRoot;
    private final String udfLibRoot;
    private final AtomicLong requestCounter;
    private static UDFExecutableManager INSTANCE = null;

    private UDFExecutableManager(String temporaryLibRoot, String udfLibRoot) {
        this.temporaryLibRoot = temporaryLibRoot;
        this.udfLibRoot = udfLibRoot;
        this.requestCounter = new AtomicLong(0L);
    }

    public UDFExecutableResource request(List<String> uris) throws URISyntaxException, IOException {
        long requestId = this.generateNextRequestId();
        this.downloadExecutables(uris, requestId);
        return new UDFExecutableResource(requestId, this.getDirStringByRequestId(requestId));
    }

    public void moveToExtLibDir(UDFExecutableResource resource, String functionName) throws IOException {
        FileUtils.moveDirectory((File)this.getDirByRequestId(resource.getRequestId()), (File)this.getDirByFunctionName(functionName));
    }

    public void removeFromTemporaryLibRoot(UDFExecutableResource resource) {
        this.removeFromTemporaryLibRoot(resource.getRequestId());
    }

    public void removeFromExtLibDir(String functionName) {
        FileUtils.deleteQuietly((File)this.getDirByFunctionName(functionName));
    }

    private synchronized long generateNextRequestId() throws IOException {
        long requestId = this.requestCounter.getAndIncrement();
        while (FileUtils.isDirectory((File)this.getDirByRequestId(requestId), (LinkOption[])new LinkOption[0])) {
            requestId = this.requestCounter.getAndIncrement();
        }
        FileUtils.forceMkdir((File)this.getDirByRequestId(requestId));
        return requestId;
    }

    private void downloadExecutables(List<String> uris, long requestId) throws IOException, URISyntaxException {
        try {
            for (String uriString : uris) {
                URL url = new URI(uriString).toURL();
                String fileName = uriString.substring(uriString.lastIndexOf("/") + 1);
                String destination = this.temporaryLibRoot + File.separator + requestId + File.separator + fileName;
                FileUtils.copyURLToFile((URL)url, (File)FSFactoryProducer.getFSFactory().getFile(destination));
            }
        }
        catch (Exception e) {
            this.removeFromTemporaryLibRoot(requestId);
            throw e;
        }
    }

    private void removeFromTemporaryLibRoot(long requestId) {
        FileUtils.deleteQuietly((File)this.getDirByRequestId(requestId));
    }

    public File getDirByRequestId(long requestId) {
        return FSFactoryProducer.getFSFactory().getFile(this.getDirStringByRequestId(requestId));
    }

    public String getDirStringByRequestId(long requestId) {
        return this.temporaryLibRoot + File.separator + requestId + File.separator;
    }

    public File getDirByFunctionName(String functionName) {
        return FSFactoryProducer.getFSFactory().getFile(this.getDirStringByFunctionName(functionName));
    }

    public String getDirStringByFunctionName(String functionName) {
        return this.udfLibRoot + File.separator + functionName + File.separator;
    }

    @Override
    public void start() throws StartupException {
        try {
            UDFExecutableManager.makeDirIfNecessary(this.temporaryLibRoot);
            UDFExecutableManager.makeDirIfNecessary(this.udfLibRoot);
        }
        catch (Exception e) {
            throw new StartupException(e);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public ServiceType getID() {
        return ServiceType.UDF_EXECUTABLE_MANAGER_SERVICE;
    }

    public static synchronized UDFExecutableManager setupAndGetInstance(String temporaryLibRoot, String udfLibRoot) {
        if (INSTANCE == null) {
            INSTANCE = new UDFExecutableManager(temporaryLibRoot, udfLibRoot);
        }
        return INSTANCE;
    }

    private static void makeDirIfNecessary(String dir) throws IOException {
        File file = SystemFileFactory.INSTANCE.getFile(dir);
        if (file.exists() && file.isDirectory()) {
            return;
        }
        FileUtils.forceMkdir((File)file);
    }

    public static UDFExecutableManager getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        return SnapshotUtils.takeSnapshotForDir(this.temporaryLibRoot, snapshotDir.getAbsolutePath() + File.separator + "ext" + File.separator + "temporary") && SnapshotUtils.takeSnapshotForDir(this.udfLibRoot, snapshotDir.getAbsolutePath() + File.separator + "ext" + File.separator + "udf");
    }

    @Override
    public void processLoadSnapshot(File snapshotDir) throws IOException {
        SnapshotUtils.loadSnapshotForDir(snapshotDir.getAbsolutePath() + File.separator + "ext" + File.separator + "temporary", this.temporaryLibRoot);
        SnapshotUtils.loadSnapshotForDir(snapshotDir.getAbsolutePath() + File.separator + "ext" + File.separator + "udf", this.udfLibRoot);
    }
}

