/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.file;

import java.io.File;
import java.net.URI;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.tsfile.fileSystem.FSType;

public enum SystemFileFactory {
    INSTANCE;

    private static FSType fsType;
    private static final String UNSUPPORT_FILE_SYSTEM = "Unsupported file system: ";

    public File getFile(String pathname) {
        if (fsType.equals((Object)FSType.HDFS)) {
            throw new UnsupportedOperationException(UNSUPPORT_FILE_SYSTEM + fsType.name());
        }
        return new File(pathname);
    }

    public File getFile(String parent, String child) {
        if (fsType.equals((Object)FSType.HDFS)) {
            throw new UnsupportedOperationException(UNSUPPORT_FILE_SYSTEM + fsType.name());
        }
        return new File(parent, child);
    }

    public File getFile(File parent, String child) {
        if (fsType.equals((Object)FSType.HDFS)) {
            throw new UnsupportedOperationException(UNSUPPORT_FILE_SYSTEM + fsType.name());
        }
        return new File(parent, child);
    }

    public File getFile(URI uri) {
        if (fsType.equals((Object)FSType.HDFS)) {
            throw new UnsupportedOperationException(UNSUPPORT_FILE_SYSTEM + fsType.name());
        }
        return new File(uri);
    }

    static {
        fsType = CommonDescriptor.getInstance().getConfig().getSystemFileStorageFs();
    }
}

