/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.recover;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.memtable.AbstractMemTable;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.wal.WALManager;
import org.apache.iotdb.db.wal.buffer.WALEntry;
import org.apache.iotdb.db.wal.buffer.WALEntryType;
import org.apache.iotdb.db.wal.checkpoint.MemTableInfo;
import org.apache.iotdb.db.wal.io.WALReader;
import org.apache.iotdb.db.wal.recover.CheckpointRecoverUtils;
import org.apache.iotdb.db.wal.recover.WALRecoverManager;
import org.apache.iotdb.db.wal.recover.file.UnsealedTsFileRecoverPerformer;
import org.apache.iotdb.db.wal.utils.CheckpointFileUtils;
import org.apache.iotdb.db.wal.utils.WALFileStatus;
import org.apache.iotdb.db.wal.utils.WALFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WALNodeRecoverTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(WALNodeRecoverTask.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final WALRecoverManager walRecoverManger = WALRecoverManager.getInstance();
    private final File logDirectory;
    private final CountDownLatch allNodesRecoveredLatch;
    private long firstValidVersionId = Long.MAX_VALUE;
    private Map<Long, MemTableInfo> memTableId2Info;
    private Map<Long, UnsealedTsFileRecoverPerformer> memTableId2RecoverPerformer;

    public WALNodeRecoverTask(File logDirectory, CountDownLatch allNodesRecoveredLatch) {
        this.logDirectory = logDirectory;
        this.allNodesRecoveredLatch = allNodesRecoveredLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("Start recovering WAL node in the directory {}", (Object)this.logDirectory);
        try {
            this.recoverInfoFromCheckpoints();
            this.recoverTsFiles();
        }
        catch (Exception e) {
            for (UnsealedTsFileRecoverPerformer recoverPerformer2 : this.memTableId2RecoverPerformer.values()) {
                recoverPerformer2.getRecoverListener().fail(e);
            }
        }
        finally {
            this.allNodesRecoveredLatch.countDown();
            for (UnsealedTsFileRecoverPerformer unsealedTsFileRecoverPerformer : this.memTableId2RecoverPerformer.values()) {
                try {
                    if (unsealedTsFileRecoverPerformer.canWrite()) continue;
                    unsealedTsFileRecoverPerformer.close();
                }
                catch (Exception recoverPerformer2) {}
            }
        }
        if (!config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.multileader.MultiLeaderConsensus")) {
            FileUtils.deleteDirectory((File)this.logDirectory);
            logger.info("Successfully recover WAL node in the directory {}, so delete these wal files.", (Object)this.logDirectory);
        } else {
            File[] checkpointFiles;
            for (File checkpointFile : checkpointFiles = CheckpointFileUtils.listAllCheckpointFiles(this.logDirectory)) {
                checkpointFile.delete();
            }
            long[] lArray = this.recoverLastSearchIndex();
            long lastVersionId = lArray[0];
            long lastSearchIndex = lArray[1];
            WALManager.getInstance().registerWALNode(this.logDirectory.getName(), this.logDirectory.getAbsolutePath(), lastVersionId + 1L, lastSearchIndex);
            logger.info("Successfully recover WAL node in the directory {}, add this node to WALManger.", (Object)this.logDirectory);
        }
    }

    private long[] recoverLastSearchIndex() {
        String targetName;
        File[] walFiles = WALFileUtils.listAllWALFiles(this.logDirectory);
        if (walFiles == null || walFiles.length == 0) {
            return new long[]{0L, 0L};
        }
        WALFileUtils.ascSortByVersionId(walFiles);
        File lastWALFile = walFiles[walFiles.length - 1];
        long lastVersionId = WALFileUtils.parseVersionId(lastWALFile.getName());
        long lastSearchIndex = WALFileUtils.parseStartSearchIndex(lastWALFile.getName());
        WALFileStatus fileStatus = WALFileStatus.CONTAINS_NONE_SEARCH_INDEX;
        try (WALReader walReader = new WALReader(lastWALFile);){
            while (walReader.hasNext()) {
                InsertNode insertNode;
                WALEntry walEntry = walReader.next();
                if (walEntry.getType() != WALEntryType.INSERT_TABLET_NODE && walEntry.getType() != WALEntryType.INSERT_ROW_NODE || (insertNode = (InsertNode)((Object)walEntry.getValue())).getSearchIndex() == -1L) continue;
                lastSearchIndex = Math.max(lastSearchIndex, insertNode.getSearchIndex());
                fileStatus = WALFileStatus.CONTAINS_SEARCH_INDEX;
            }
        }
        catch (Exception e) {
            logger.warn("Fail to read wal logs from {}, skip them", (Object)lastWALFile, (Object)e);
        }
        if (WALFileUtils.parseStatusCode(lastWALFile.getName()) != fileStatus && !lastWALFile.renameTo(SystemFileFactory.INSTANCE.getFile(this.logDirectory, targetName = WALFileUtils.getLogFileName(WALFileUtils.parseVersionId(lastWALFile.getName()), WALFileUtils.parseStartSearchIndex(lastWALFile.getName()), fileStatus)))) {
            logger.error("Fail to rename file {} to {}", (Object)lastWALFile, (Object)targetName);
        }
        return new long[]{lastVersionId, lastSearchIndex};
    }

    private void recoverInfoFromCheckpoints() {
        CheckpointRecoverUtils.CheckpointInfo info = CheckpointRecoverUtils.recoverMemTableInfo(this.logDirectory);
        this.memTableId2Info = info.getMemTableId2Info();
        this.memTableId2RecoverPerformer = new HashMap<Long, UnsealedTsFileRecoverPerformer>();
        long maxMemTableId = info.getMaxMemTableId();
        AtomicLong memTableIdCounter = AbstractMemTable.memTableIdCounter;
        long oldVal = memTableIdCounter.get();
        while (maxMemTableId > oldVal) {
            if (memTableIdCounter.compareAndSet(oldVal, maxMemTableId)) continue;
            oldVal = memTableIdCounter.get();
        }
        for (MemTableInfo memTableInfo : this.memTableId2Info.values()) {
            this.firstValidVersionId = Math.min(this.firstValidVersionId, memTableInfo.getFirstFileVersionId());
            File tsFile = new File(memTableInfo.getTsFilePath());
            UnsealedTsFileRecoverPerformer recoverPerformer = walRecoverManger.removeRecoverPerformer(tsFile.getAbsolutePath());
            if (recoverPerformer == null) continue;
            this.memTableId2RecoverPerformer.put(memTableInfo.getMemTableId(), recoverPerformer);
        }
    }

    private void recoverTsFiles() {
        if (this.memTableId2RecoverPerformer.isEmpty()) {
            return;
        }
        for (UnsealedTsFileRecoverPerformer recoverPerformer : this.memTableId2RecoverPerformer.values()) {
            try {
                recoverPerformer.startRecovery();
            }
            catch (Exception e) {
                recoverPerformer.getRecoverListener().fail(e);
            }
        }
        File[] walFiles = this.logDirectory.listFiles((dir, name) -> WALFileUtils.walFilenameFilter(dir, name) && WALFileUtils.parseVersionId(name) >= this.firstValidVersionId);
        if (walFiles == null) {
            return;
        }
        WALFileUtils.ascSortByVersionId(walFiles);
        for (File walFile : walFiles) {
            try (WALReader walReader = new WALReader(walFile);){
                while (walReader.hasNext()) {
                    WALEntry walEntry = walReader.next();
                    if (!this.memTableId2Info.containsKey(walEntry.getMemTableId())) continue;
                    UnsealedTsFileRecoverPerformer recoverPerformer = this.memTableId2RecoverPerformer.get(walEntry.getMemTableId());
                    if (recoverPerformer != null) {
                        recoverPerformer.redoLog(walEntry);
                        continue;
                    }
                    logger.warn("Fail to find TsFile recover performer for wal entry in TsFile {}", (Object)walFile);
                }
            }
            catch (Exception e) {
                logger.warn("Fail to read wal logs from {}, skip them", (Object)walFile, (Object)e);
            }
        }
        for (UnsealedTsFileRecoverPerformer recoverPerformer : this.memTableId2RecoverPerformer.values()) {
            try {
                recoverPerformer.endRecovery();
                recoverPerformer.getRecoverListener().succeed();
            }
            catch (Exception e) {
                recoverPerformer.getRecoverListener().fail(e);
            }
        }
    }
}

