/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.pipe;

import java.util.List;
import org.apache.iotdb.db.exception.sync.PipeSinkException;
import org.apache.iotdb.db.sync.externalpipe.ExtPipePluginRegister;
import org.apache.iotdb.db.sync.sender.pipe.ExternalPipeSink;
import org.apache.iotdb.db.sync.sender.pipe.IoTDBPipeSink;
import org.apache.iotdb.tsfile.utils.Pair;

public interface PipeSink {
    public void setAttribute(List<Pair<String, String>> var1) throws PipeSinkException;

    public String getPipeSinkName();

    public PipeSinkType getType();

    public String showAllAttributes();

    public static class PipeSinkFactory {
        public static PipeSink createPipeSink(String type, String name) {
            type = type.toLowerCase();
            if (PipeSinkType.IoTDB.name().toLowerCase().equals(type)) {
                return new IoTDBPipeSink(name);
            }
            if (ExtPipePluginRegister.getInstance().pluginExist(type)) {
                return new ExternalPipeSink(name, type);
            }
            throw new UnsupportedOperationException(String.format("Do not support pipeSink type: %s.", type));
        }
    }

    public static enum PipeSinkType {
        IoTDB,
        ExternalPipe;

    }
}

