/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.pipe;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.db.exception.sync.PipeSinkException;
import org.apache.iotdb.db.sync.externalpipe.ExtPipePluginRegister;
import org.apache.iotdb.db.sync.sender.pipe.PipeSink;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalPipeSink
implements PipeSink {
    private static final Logger logger = LoggerFactory.getLogger(ExternalPipeSink.class);
    private final PipeSink.PipeSinkType pipeSinkType = PipeSink.PipeSinkType.ExternalPipe;
    private final String pipeSinkName;
    private final String extPipeSinkTypeName;
    private Map<String, String> sinkParams;

    public ExternalPipeSink(String pipeSinkName, String extPipeSinkTypeName) {
        this.pipeSinkName = pipeSinkName;
        this.extPipeSinkTypeName = extPipeSinkTypeName;
    }

    @Override
    public void setAttribute(List<Pair<String, String>> params) throws PipeSinkException {
        String regex = "^'|'$|^\"|\"$";
        this.sinkParams = params.stream().collect(Collectors.toMap(e -> (String)e.left, e -> ((String)e.right).trim().replaceAll(regex, ""), (key1, key2) -> key2));
        try {
            ExtPipePluginRegister.getInstance().getWriteFactory(this.extPipeSinkTypeName).validateSinkParams(this.sinkParams);
        }
        catch (Exception e2) {
            throw new PipeSinkException(e2.getMessage());
        }
    }

    @Override
    public String getPipeSinkName() {
        return this.pipeSinkName;
    }

    @Override
    public PipeSink.PipeSinkType getType() {
        return this.pipeSinkType;
    }

    @Override
    public String showAllAttributes() {
        return this.sinkParams.entrySet().stream().filter(e -> !((String)e.getKey()).contains("access_key")).collect(Collectors.toList()).toString();
    }

    public Map<String, String> getSinkParams() {
        return this.sinkParams;
    }

    public String getExtPipeSinkTypeName() {
        return this.extPipeSinkTypeName;
    }
}

