/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver.load;

import java.io.File;
import java.util.ArrayList;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.exception.sync.PipeDataLoadException;
import org.apache.iotdb.db.exception.sync.PipeDataLoadUnbearableException;
import org.apache.iotdb.db.sync.receiver.load.ILoader;
import org.apache.iotdb.db.tools.TsFileRewriteTool;
import org.apache.iotdb.db.utils.FileLoaderUtils;

public class TsFileLoader
implements ILoader {
    private File tsFile;

    public TsFileLoader(File tsFile) {
        this.tsFile = tsFile;
    }

    @Override
    public void load() throws PipeDataLoadException {
        try {
            TsFileResource tsFileResource = new TsFileResource(this.tsFile);
            tsFileResource.setStatus(TsFileResourceStatus.CLOSED);
            FileLoaderUtils.loadOrGenerateResource(tsFileResource);
            ArrayList<TsFileResource> splitResources = new ArrayList<TsFileResource>();
            if (tsFileResource.isSpanMultiTimePartitions()) {
                TsFileRewriteTool.rewriteTsFile(tsFileResource, splitResources);
                tsFileResource.writeLock();
                tsFileResource.removeModFile();
                tsFileResource.writeUnlock();
            }
            if (splitResources.isEmpty()) {
                splitResources.add(tsFileResource);
            }
            for (TsFileResource resource : splitResources) {
                StorageEngine.getInstance().loadNewTsFile(resource, false);
            }
        }
        catch (Exception e) {
            throw new PipeDataLoadUnbearableException(e.getMessage());
        }
    }
}

