/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.datasource;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.sync.datasource.AbstractOpBlock;
import org.apache.iotdb.db.sync.datasource.PipeOpSgManager;
import org.apache.iotdb.db.sync.datasource.TsFileOpBlock;
import org.apache.iotdb.db.sync.externalpipe.operation.Operation;
import org.apache.iotdb.db.sync.sender.pipe.TsFilePipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeOpManager {
    private static final Logger logger = LoggerFactory.getLogger(PipeOpManager.class);
    TsFilePipe filePipe;
    private Map<String, PipeOpSgManager> pipeSgManagerMap = new ConcurrentHashMap<String, PipeOpSgManager>();
    private TreeSet<Long> filePipeSerialNumberSet = new TreeSet();
    private Long maxFilePipeSerialNumber = Long.MIN_VALUE;

    public PipeOpManager(TsFilePipe filePipe) {
        this.filePipe = filePipe;
    }

    public Set<String> getSgSet() {
        return this.pipeSgManagerMap.keySet();
    }

    public void appendDataSrc(String sgName, AbstractOpBlock dataSrcEntry) {
        PipeOpSgManager pipeOpSgManager = this.pipeSgManagerMap.get(sgName);
        if (pipeOpSgManager == null) {
            pipeOpSgManager = new PipeOpSgManager(sgName);
            this.pipeSgManagerMap.put(sgName, pipeOpSgManager);
        }
        pipeOpSgManager.addPipeOpBlock(dataSrcEntry);
    }

    public void appendTsFile(String sgName, String tsFilename, long pipeDataSerialNumber) throws IOException {
        File file = new File(tsFilename);
        if (!file.exists()) {
            logger.error("appendTsFile(), can not find TsFile: {}", (Object)tsFilename);
            throw new IOException("No TsFile: " + tsFilename);
        }
        this.filePipeSerialNumberSet.add(pipeDataSerialNumber);
        if (pipeDataSerialNumber > this.maxFilePipeSerialNumber) {
            this.maxFilePipeSerialNumber = pipeDataSerialNumber;
        }
        TsFileOpBlock tsfileDataSrcEntry = new TsFileOpBlock(sgName, tsFilename, pipeDataSerialNumber);
        this.appendDataSrc(sgName, tsfileDataSrcEntry);
    }

    public Operation getOperation(String sgName, long index, long length) throws IOException {
        logger.debug("getOperation(), sgName={}, index={}, length={}.", new Object[]{sgName, index, length});
        PipeOpSgManager pipeOpSgManager = this.pipeSgManagerMap.get(sgName);
        if (pipeOpSgManager == null) {
            logger.error("getOperation(), invalid sgName = {}. continue.", (Object)sgName);
            return null;
        }
        return pipeOpSgManager.getOperation(index, length);
    }

    public long getCommittedIndex(String sgName) {
        return this.getFirstAvailableIndex(sgName) - 1L;
    }

    public long getFirstAvailableIndex(String sgName) {
        try {
            return this.pipeSgManagerMap.get(sgName).getFirstAvailableIndex();
        }
        catch (NullPointerException e) {
            logger.error("getFirstAvailableIndex(), Can not find sgName: {}.", (Object)sgName);
            throw new IllegalArgumentException("getFirstAvailableIndex(), Can not find sgName: " + sgName);
        }
    }

    private void commitFilePipe(List<Long> filePipeSerialNumberList) {
        if (this.filePipe == null) {
            return;
        }
        if (filePipeSerialNumberList.size() <= 0) {
            return;
        }
        if (this.filePipeSerialNumberSet.size() <= 0) {
            logger.error("commitFilePipe(), filePipeSerialNumberSet should not be empty.");
            return;
        }
        long minNum = this.filePipeSerialNumberSet.first();
        long maxNum = this.filePipeSerialNumberSet.last();
        for (long filePipeSerialNumber : filePipeSerialNumberList) {
            if (this.filePipeSerialNumberSet.remove(filePipeSerialNumber)) continue;
            logger.error("commitFilePipe(), invalid filePipeSerialNumber={}.", (Object)filePipeSerialNumber);
        }
        if (this.filePipeSerialNumberSet.size() > 0) {
            if (this.filePipeSerialNumberSet.first() > minNum) {
                this.filePipe.commit(this.filePipeSerialNumberSet.first() - 1L);
            }
            return;
        }
        this.filePipe.commit(this.maxFilePipeSerialNumber);
    }

    public void commitData(String sgName, long committedIndex) {
        logger.debug("PipeOpManager commitData(), sgName={}, committedIndex={}.", (Object)sgName, (Object)committedIndex);
        PipeOpSgManager pipeOpSgManager = this.pipeSgManagerMap.get(sgName);
        if (pipeOpSgManager == null) {
            logger.error("commitData(), invalid sgName = {}, continue.", (Object)sgName);
            return;
        }
        List<Long> filePipeSerialNumberList = pipeOpSgManager.commitData(committedIndex);
        this.commitFilePipe(filePipeSerialNumberList);
    }

    public long getNextIndex(String sgName) {
        PipeOpSgManager pipeOpSgManager = this.pipeSgManagerMap.get(sgName);
        if (pipeOpSgManager == null) {
            logger.error("getNextIndex(), can not find Storage Group: {}.", (Object)sgName);
            return Long.MIN_VALUE;
        }
        return pipeOpSgManager.getNextIndex();
    }

    public void close() {
        for (String sgName : this.pipeSgManagerMap.keySet()) {
            this.commitData(sgName, Long.MAX_VALUE);
        }
    }
}

