/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.db.protocol.influxdb.meta.InfluxDBMetaManager;
import org.apache.iotdb.db.protocol.influxdb.util.CommonUtils;
import org.apache.iotdb.db.protocol.influxdb.util.FieldUtils;
import org.apache.iotdb.db.protocol.influxdb.util.StringUtils;
import org.apache.iotdb.db.query.dataset.AlignByDeviceDataSet;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.influxdb.dto.QueryResult;

public class QueryResultUtils {
    public static void updateQueryResultColumnValue(QueryResult queryResult, List<String> columns, List<List<Object>> updateValues) {
        List results = queryResult.getResults();
        QueryResult.Result result = (QueryResult.Result)results.get(0);
        List series = ((QueryResult.Result)results.get(0)).getSeries();
        QueryResult.Series serie = (QueryResult.Series)series.get(0);
        serie.setValues(updateValues);
        serie.setColumns(columns);
        series.set(0, serie);
        result.setSeries(series);
        results.set(0, result);
    }

    public static QueryResult iotdbResultConvertInfluxResult(QueryDataSet queryDataSet, String database, String measurement, Map<String, Integer> fieldOrders) throws IOException {
        if (queryDataSet == null) {
            return QueryResultUtils.getNullQueryResult();
        }
        QueryResult.Series series = new QueryResult.Series();
        series.setName(measurement);
        Map<String, Integer> tagOrders = InfluxDBMetaManager.getTagOrders(database, measurement);
        Map<Integer, String> tagOrderReversed = tagOrders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        Map<Integer, String> fieldOrdersReversed = fieldOrders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        int tagSize = tagOrderReversed.size();
        ArrayList<String> tagList = new ArrayList<String>();
        for (int i = 1; i <= tagSize; ++i) {
            tagList.add(tagOrderReversed.get(i));
        }
        ArrayList<String> fieldList = new ArrayList<String>();
        for (int i = 1 + tagSize; i < 1 + tagSize + fieldOrders.size(); ++i) {
            fieldList.add(fieldOrdersReversed.get(i));
        }
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("time");
        columns.addAll(tagList);
        columns.addAll(fieldList);
        series.setColumns(columns);
        ArrayList<List<Object>> values = new ArrayList<List<Object>>();
        while (queryDataSet.hasNext()) {
            int i;
            Object[] value = new Object[columns.size()];
            RowRecord record = queryDataSet.next();
            List fields = record.getFields();
            value[0] = record.getTimestamp();
            String deviceName = ((Field)fields.get(0)).getStringValue();
            String[] deviceNameList = deviceName.split("\\.");
            for (i = 3; i < deviceNameList.length; ++i) {
                if (deviceNameList[i].equals("PH")) continue;
                value[i - 2] = deviceNameList[i];
            }
            for (i = 1; i < fields.size(); ++i) {
                Object o = FieldUtils.iotdbFieldConvert((Field)fields.get(i));
                if (o == null) continue;
                value[fieldOrders.get((Object)((AlignByDeviceDataSet)queryDataSet).getMeasurements().get((int)(i - 1))).intValue()] = o;
            }
            values.add(Arrays.asList(value));
        }
        series.setValues(values);
        QueryResult queryResult = new QueryResult();
        QueryResult.Result result = new QueryResult.Result();
        result.setSeries(new ArrayList<QueryResult.Series>(Arrays.asList(series)));
        queryResult.setResults(new ArrayList<QueryResult.Result>(Arrays.asList(result)));
        return queryResult;
    }

    public static QueryResult getNullQueryResult() {
        QueryResult queryResult = new QueryResult();
        QueryResult.Result result = new QueryResult.Result();
        queryResult.setResults(Arrays.asList(result));
        return queryResult;
    }

    private static void updateQueryResultValue(QueryResult queryResult, List<List<Object>> updateValues) {
        List results = queryResult.getResults();
        QueryResult.Result result = (QueryResult.Result)results.get(0);
        List series = ((QueryResult.Result)results.get(0)).getSeries();
        QueryResult.Series serie = (QueryResult.Series)series.get(0);
        serie.setValues(updateValues);
        series.set(0, serie);
        result.setSeries(series);
        results.set(0, result);
    }

    private static boolean checkSameQueryResult(QueryResult queryResult1, QueryResult queryResult2) {
        return ((QueryResult.Series)((QueryResult.Result)queryResult1.getResults().get(0)).getSeries().get(0)).getName().equals(((QueryResult.Series)((QueryResult.Result)queryResult2.getResults().get(0)).getSeries().get(0)).getName()) && StringUtils.checkSameStringList(((QueryResult.Series)((QueryResult.Result)queryResult1.getResults().get(0)).getSeries().get(0)).getColumns(), ((QueryResult.Series)((QueryResult.Result)queryResult2.getResults().get(0)).getSeries().get(0)).getColumns());
    }

    public static QueryResult orQueryResultProcess(QueryResult queryResult1, QueryResult queryResult2) {
        if (QueryResultUtils.checkQueryResultNull(queryResult1)) {
            return queryResult2;
        }
        if (QueryResultUtils.checkQueryResultNull(queryResult2)) {
            return queryResult1;
        }
        if (!QueryResultUtils.checkSameQueryResult(queryResult1, queryResult2)) {
            System.out.println("QueryResult1 and QueryResult2 is not same attribute");
            return queryResult1;
        }
        List values1 = ((QueryResult.Series)((QueryResult.Result)queryResult1.getResults().get(0)).getSeries().get(0)).getValues();
        List values2 = ((QueryResult.Series)((QueryResult.Result)queryResult2.getResults().get(0)).getSeries().get(0)).getValues();
        ArrayList<List> notSameValuesInValues1 = new ArrayList<List>();
        for (List value1 : values1) {
            boolean allNotEqual = true;
            for (List value2 : values2) {
                boolean notEqual = false;
                for (int t = 0; t < value1.size(); ++t) {
                    if (CommonUtils.checkEqualsContainNull(value1.get(t), value2.get(t))) continue;
                    notEqual = true;
                    break;
                }
                if (notEqual) continue;
                allNotEqual = false;
                break;
            }
            if (!allNotEqual) continue;
            notSameValuesInValues1.add(value1);
        }
        values2.addAll(notSameValuesInValues1);
        QueryResultUtils.updateQueryResultValue(queryResult1, values2);
        return queryResult1;
    }

    public static QueryResult andQueryResultProcess(QueryResult queryResult1, QueryResult queryResult2) {
        if (QueryResultUtils.checkQueryResultNull(queryResult1) || QueryResultUtils.checkQueryResultNull(queryResult2)) {
            return QueryResultUtils.getNullQueryResult();
        }
        if (!QueryResultUtils.checkSameQueryResult(queryResult1, queryResult2)) {
            System.out.println("QueryResult1 and QueryResult2 is not same attribute");
            return queryResult1;
        }
        List values1 = ((QueryResult.Series)((QueryResult.Result)queryResult1.getResults().get(0)).getSeries().get(0)).getValues();
        List values2 = ((QueryResult.Series)((QueryResult.Result)queryResult2.getResults().get(0)).getSeries().get(0)).getValues();
        ArrayList<List<Object>> sameValues = new ArrayList<List<Object>>();
        for (List value1 : values1) {
            for (List value2 : values2) {
                boolean allEqual = true;
                for (int t = 0; t < value1.size(); ++t) {
                    if (CommonUtils.checkEqualsContainNull(value1.get(t), value2.get(t))) continue;
                    allEqual = false;
                    break;
                }
                if (!allEqual) continue;
                sameValues.add(value1);
            }
        }
        QueryResultUtils.updateQueryResultValue(queryResult1, sameValues);
        return queryResult1;
    }

    public static boolean checkQueryResultNull(QueryResult queryResult) {
        return ((QueryResult.Result)queryResult.getResults().get(0)).getSeries() == null;
    }
}

