/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.udf;

import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.udf.service.UDFRegistrationService;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDTFTypeInferrer {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDTFTypeInferrer.class);
    protected final String functionName;

    public UDTFTypeInferrer(String functionName) {
        this.functionName = functionName;
    }

    public TSDataType inferOutputType(List<String> childExpressions, List<TSDataType> childExpressionDataTypes, Map<String, String> attributes) {
        try {
            UDTF udtf = (UDTF)UDFRegistrationService.getInstance().reflect(this.functionName);
            UDFParameters parameters = new UDFParameters(childExpressions, UDFDataTypeTransformer.transformToUDFDataTypeList(childExpressionDataTypes), attributes);
            udtf.validate(new UDFParameterValidator(parameters));
            UDTFConfigurations configurations = new UDTFConfigurations(ZoneId.systemDefault());
            udtf.beforeStart(parameters, configurations);
            udtf.beforeDestroy();
            return UDFDataTypeTransformer.transformToTsDataType((Type)configurations.getOutputDataType());
        }
        catch (Exception e) {
            LOGGER.warn("Error occurred during inferring UDF data type", (Throwable)e);
            throw new SemanticException(String.format("Error occurred during inferring UDF data type: %s", System.lineSeparator()) + e);
        }
    }
}

