/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ProcessNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.statement.component.OrderBy;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SlidingWindowAggregationNode
extends ProcessNode {
    private List<AggregationDescriptor> aggregationDescriptorList;
    private final GroupByTimeParameter groupByTimeParameter;
    protected OrderBy scanOrder = OrderBy.TIMESTAMP_ASC;
    private PlanNode child;

    public SlidingWindowAggregationNode(PlanNodeId id, List<AggregationDescriptor> aggregationDescriptorList, GroupByTimeParameter groupByTimeParameter, OrderBy scanOrder) {
        super(id);
        this.aggregationDescriptorList = aggregationDescriptorList;
        this.groupByTimeParameter = groupByTimeParameter;
        this.scanOrder = scanOrder;
    }

    public SlidingWindowAggregationNode(PlanNodeId id, PlanNode child, List<AggregationDescriptor> aggregationDescriptorList, GroupByTimeParameter groupByTimeParameter, OrderBy scanOrder) {
        this(id, aggregationDescriptorList, groupByTimeParameter, scanOrder);
        this.child = child;
    }

    public List<AggregationDescriptor> getAggregationDescriptorList() {
        return this.aggregationDescriptorList;
    }

    public void setAggregationDescriptorList(List<AggregationDescriptor> aggregationDescriptorList) {
        this.aggregationDescriptorList = aggregationDescriptorList;
    }

    public GroupByTimeParameter getGroupByTimeParameter() {
        return this.groupByTimeParameter;
    }

    public OrderBy getScanOrder() {
        return this.scanOrder;
    }

    public PlanNode getChild() {
        return this.child;
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of((Object)this.child);
    }

    @Override
    public void addChild(PlanNode child) {
        this.child = child;
    }

    @Override
    public int allowedChildCount() {
        return 1;
    }

    @Override
    public PlanNode clone() {
        return new SlidingWindowAggregationNode(this.getPlanNodeId(), this.getAggregationDescriptorList(), this.getGroupByTimeParameter(), this.getScanOrder());
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.aggregationDescriptorList.stream().map(AggregationDescriptor::getOutputColumnNames).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSlidingWindowAggregation(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.SLIDING_WINDOW_AGGREGATION.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.aggregationDescriptorList.size(), (ByteBuffer)byteBuffer);
        for (AggregationDescriptor aggregationDescriptor : this.aggregationDescriptorList) {
            aggregationDescriptor.serialize(byteBuffer);
        }
        if (this.groupByTimeParameter == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.groupByTimeParameter.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.SLIDING_WINDOW_AGGREGATION.serialize(stream);
        ReadWriteIOUtils.write((int)this.aggregationDescriptorList.size(), (OutputStream)stream);
        for (AggregationDescriptor aggregationDescriptor : this.aggregationDescriptorList) {
            aggregationDescriptor.serialize(stream);
        }
        if (this.groupByTimeParameter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.groupByTimeParameter.serialize(stream);
        }
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (OutputStream)stream);
    }

    public static SlidingWindowAggregationNode deserialize(ByteBuffer byteBuffer) {
        ArrayList<AggregationDescriptor> aggregationDescriptorList = new ArrayList<AggregationDescriptor>();
        for (int descriptorSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); descriptorSize > 0; --descriptorSize) {
            aggregationDescriptorList.add(AggregationDescriptor.deserialize(byteBuffer));
        }
        byte isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        GroupByTimeParameter groupByTimeParameter = null;
        if (isNull == 1) {
            groupByTimeParameter = GroupByTimeParameter.deserialize(byteBuffer);
        }
        OrderBy scanOrder = OrderBy.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new SlidingWindowAggregationNode(planNodeId, aggregationDescriptorList, groupByTimeParameter, scanOrder);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SlidingWindowAggregationNode that = (SlidingWindowAggregationNode)o;
        return Objects.equals(this.aggregationDescriptorList, that.aggregationDescriptorList) && Objects.equals(this.groupByTimeParameter, that.groupByTimeParameter) && Objects.equals(this.child, that.child);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.aggregationDescriptorList, this.groupByTimeParameter, this.child);
    }

    public String toString() {
        return String.format("SlidingWindowAggregationNode-%s", this.getPlanNodeId());
    }
}

