/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.MultiChildNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.LastQueryScanNode;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class LastQueryMergeNode
extends MultiChildNode {
    private List<PlanNode> children;
    private final Filter timeFilter;

    public LastQueryMergeNode(PlanNodeId id, Filter timeFilter) {
        super(id);
        this.children = new ArrayList<PlanNode>();
        this.timeFilter = timeFilter;
    }

    public LastQueryMergeNode(PlanNodeId id, List<PlanNode> children, Filter timeFilter) {
        super(id);
        this.children = children;
        this.timeFilter = timeFilter;
    }

    @Override
    public List<PlanNode> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(PlanNode child) {
        this.children.add(child);
    }

    @Override
    public PlanNode clone() {
        return new LastQueryMergeNode(this.getPlanNodeId(), this.timeFilter);
    }

    @Override
    public int allowedChildCount() {
        return -1;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return LastQueryScanNode.LAST_QUERY_HEADER_COLUMNS;
    }

    public String toString() {
        return String.format("LastQueryMergeNode-%s:[TimeFilter: %s]", this.getPlanNodeId(), this.timeFilter);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LastQueryMergeNode that = (LastQueryMergeNode)o;
        return Objects.equals(this.children, that.children);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.children);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitLastQueryMerge(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.LAST_QUERY_MERGE.serialize(byteBuffer);
        if (this.timeFilter == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.timeFilter.serialize(byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.LAST_QUERY_MERGE.serialize(stream);
        if (this.timeFilter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.timeFilter.serialize(stream);
        }
    }

    public static LastQueryMergeNode deserialize(ByteBuffer byteBuffer) {
        Filter timeFilter = null;
        if (ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer) == 1) {
            timeFilter = FilterFactory.deserialize((ByteBuffer)byteBuffer);
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new LastQueryMergeNode(planNodeId, timeFilter);
    }

    @Override
    public void setChildren(List<PlanNode> children) {
        this.children = children;
    }

    @Nullable
    public Filter getTimeFilter() {
        return this.timeFilter;
    }
}

