/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.leaf;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PathDeserializeUtil;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.leaf.LeafOperand;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.dag.input.QueryDataSetInputLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.IntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.SingleInputColumnMultiReferenceIntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.SingleInputColumnSingleReferenceIntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFContext;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.utils.WildcardsRemover;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class TimeSeriesOperand
extends LeafOperand {
    private PartialPath path;

    public TimeSeriesOperand(PartialPath path) {
        this.path = path;
    }

    public TimeSeriesOperand(ByteBuffer byteBuffer) {
        this.path = (PartialPath)PathDeserializeUtil.deserialize(byteBuffer);
    }

    public PartialPath getPath() {
        return this.path;
    }

    public void setPath(PartialPath path) {
        this.path = path;
    }

    @Override
    public boolean isConstantOperandInternal() {
        return false;
    }

    @Override
    public void concat(List<PartialPath> prefixPaths, List<Expression> resultExpressions) {
        for (PartialPath prefixPath : prefixPaths) {
            resultExpressions.add(new TimeSeriesOperand(prefixPath.concatPath(this.path)));
        }
    }

    @Override
    public void removeWildcards(WildcardsRemover wildcardsRemover, List<Expression> resultExpressions) throws LogicalOptimizeException {
        for (PartialPath partialPath : wildcardsRemover.removeWildcardFrom(this.path)) {
            resultExpressions.add(new TimeSeriesOperand(partialPath));
        }
    }

    @Override
    public void collectPaths(Set<PartialPath> pathSet) {
        pathSet.add(this.path);
    }

    @Override
    public TSDataType inferTypes(TypeProvider typeProvider) {
        return typeProvider.getType(this.toString());
    }

    @Override
    public void bindInputLayerColumnIndexWithExpression(UDTFPlan udtfPlan) {
        this.inputColumnIndex = udtfPlan.getReaderIndexByExpressionName(this.toString());
    }

    @Override
    public void bindInputLayerColumnIndexWithExpression(Map<String, List<InputLocation>> inputLocations) {
        String digest = this.toString();
        if (inputLocations.containsKey(digest)) {
            this.inputColumnIndex = inputLocations.get(digest).get(0).getValueColumnIndex();
        }
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
        memoryAssigner.increaseExpressionReference(this);
    }

    @Override
    public IntermediateLayer constructIntermediateLayer(long queryId, UDTFContext udtfContext, QueryDataSetInputLayer rawTimeSeriesInputLayer, Map<Expression, IntermediateLayer> expressionIntermediateLayerMap, Map<Expression, TSDataType> expressionDataTypeMap, LayerMemoryAssigner memoryAssigner) throws QueryProcessException {
        if (!expressionIntermediateLayerMap.containsKey(this)) {
            float memoryBudgetInMB = memoryAssigner.assign();
            LayerPointReader parentLayerPointReader = rawTimeSeriesInputLayer.constructValuePointReader(this.inputColumnIndex);
            expressionDataTypeMap.put(this, parentLayerPointReader.getDataType());
            expressionIntermediateLayerMap.put(this, memoryAssigner.getReference(this) == 1 ? new SingleInputColumnSingleReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, parentLayerPointReader) : new SingleInputColumnMultiReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, parentLayerPointReader));
        }
        return expressionIntermediateLayerMap.get(this);
    }

    @Override
    public IntermediateLayer constructIntermediateLayer(long queryId, UDTFContext udtfContext, QueryDataSetInputLayer rawTimeSeriesInputLayer, Map<Expression, IntermediateLayer> expressionIntermediateLayerMap, TypeProvider typeProvider, LayerMemoryAssigner memoryAssigner) throws QueryProcessException, IOException {
        if (!expressionIntermediateLayerMap.containsKey(this)) {
            float memoryBudgetInMB = memoryAssigner.assign();
            LayerPointReader parentLayerPointReader = rawTimeSeriesInputLayer.constructValuePointReader(this.inputColumnIndex);
            expressionIntermediateLayerMap.put(this, memoryAssigner.getReference(this) == 1 ? new SingleInputColumnSingleReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, parentLayerPointReader) : new SingleInputColumnMultiReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, parentLayerPointReader));
        }
        return expressionIntermediateLayerMap.get(this);
    }

    @Override
    public String getExpressionStringInternal() {
        return this.path.isMeasurementAliasExists() ? this.path.getFullPathWithAlias() : this.path.getFullPath();
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.TIMESERIES;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        this.path.serialize(byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        this.path.serialize(stream);
    }
}

