/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Metric {
    private static final Logger logger = LoggerFactory.getLogger(Metric.class);
    private static final int PRINT_RATE = 1000;
    public String stepName;
    public long invokeCount;
    public long totalTime;
    public long lastCycleTime;

    public Metric(String stepName) {
        this.stepName = stepName;
        this.invokeCount = 0L;
        this.totalTime = 0L;
        this.lastCycleTime = 0L;
    }

    public void trace(long startTime, long endTime) {
        ++this.invokeCount;
        this.totalTime += endTime - startTime;
    }

    public void tryPrint() {
        if (this.invokeCount % 1000L == 0L) {
            logger.info(String.format("step metrics [%d]-[%s] - Total: %d, SUM: %.2fms, AVG: %fms, Last%dAVG: %fms", Thread.currentThread().getId(), this.stepName, this.invokeCount, (double)this.totalTime * 1.0 / 1000000.0, (double)this.totalTime * 1.0 / 1000000.0 / (double)this.invokeCount, 1000, ((double)this.totalTime * 1.0 - (double)this.lastCycleTime) / 1000000.0 / 1000.0));
            this.lastCycleTime = this.totalTime;
        }
    }
}

