/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common.schematree.node;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.iotdb.db.mpp.common.schematree.node.SchemaNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class SchemaMeasurementNode
extends SchemaNode {
    private String alias;
    private MeasurementSchema schema;

    public SchemaMeasurementNode(String name, MeasurementSchema schema) {
        super(name);
        this.schema = schema;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public MeasurementSchema getSchema() {
        return this.schema;
    }

    @Override
    public void replaceChild(String name, SchemaNode newChild) {
        throw new UnsupportedOperationException("This operation is not supported in SchemaMeasurementNode.");
    }

    @Override
    public void copyDataTo(SchemaNode schemaNode) {
        if (!schemaNode.isMeasurement()) {
            return;
        }
        SchemaMeasurementNode measurementNode = schemaNode.getAsMeasurementNode();
        measurementNode.setSchema(this.schema);
        measurementNode.setAlias(this.alias);
    }

    private void setSchema(MeasurementSchema schema) {
        this.schema = schema;
    }

    @Override
    public boolean isMeasurement() {
        return true;
    }

    @Override
    public SchemaMeasurementNode getAsMeasurementNode() {
        return this;
    }

    @Override
    public byte getType() {
        return 2;
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)this.getType(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.name, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.alias, (OutputStream)outputStream);
        this.schema.serializeTo(outputStream);
    }

    public static SchemaMeasurementNode deserialize(InputStream inputStream) throws IOException {
        String name = ReadWriteIOUtils.readString((InputStream)inputStream);
        String alias = ReadWriteIOUtils.readString((InputStream)inputStream);
        MeasurementSchema schema = MeasurementSchema.deserializeFrom((InputStream)inputStream);
        SchemaMeasurementNode measurementNode = new SchemaMeasurementNode(name, schema);
        measurementNode.setAlias(alias);
        return measurementNode;
    }
}

