/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common.schematree;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.schematree.PathPatternNode;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PathPatternTree {
    private PathPatternNode root = new PathPatternNode("root");
    private List<PartialPath> pathPatternList = new ArrayList<PartialPath>();

    public PathPatternNode getRoot() {
        return this.root;
    }

    public void setRoot(PathPatternNode root) {
        this.root = root;
    }

    public void appendFullPath(PartialPath fullPath) {
        this.appendBranchWithoutPrune(this.root, fullPath.getNodes(), 0);
    }

    public void appendFullPath(PartialPath devicePath, String measurement) {
        int deviceNodeLength = devicePath.getNodeLength();
        String[] pathNodes = new String[deviceNodeLength + 1];
        System.arraycopy(devicePath.getNodes(), 0, pathNodes, 0, deviceNodeLength);
        pathNodes[deviceNodeLength] = measurement;
        this.appendBranchWithoutPrune(this.root, pathNodes, 0);
    }

    public void appendPathPattern(PartialPath pathPattern) {
        boolean isExist = false;
        for (PartialPath path : this.pathPatternList) {
            if (!path.matchFullPath(pathPattern)) continue;
            isExist = true;
            break;
        }
        if (!isExist) {
            this.pathPatternList.removeAll(this.pathPatternList.stream().filter(arg_0 -> ((PartialPath)pathPattern).matchFullPath(arg_0)).collect(Collectors.toList()));
            this.pathPatternList.add(pathPattern);
        }
    }

    public void constructTree() {
        for (PartialPath path : this.pathPatternList) {
            this.appendBranchWithoutPrune(this.root, path.getNodes(), 0);
        }
        this.pathPatternList.clear();
    }

    private void appendBranchWithoutPrune(PathPatternNode curNode, String[] pathNodes, int pos) {
        if (pos == pathNodes.length - 1) {
            return;
        }
        PathPatternNode nextNode = curNode.getChildren(pathNodes[pos + 1]);
        if (nextNode != null) {
            this.appendBranchWithoutPrune(nextNode, pathNodes, pos + 1);
        } else {
            this.constructBranch(curNode, pathNodes, pos + 1);
        }
    }

    private void constructBranch(PathPatternNode curNode, String[] pathNodes, int pos) {
        for (int i = pos; i < pathNodes.length; ++i) {
            PathPatternNode newNode = new PathPatternNode(pathNodes[i]);
            curNode.addChild(newNode);
            curNode = newNode;
        }
    }

    public boolean isEmpty() {
        return !(this.root.getChildren() != null && !this.root.getChildren().isEmpty() || this.pathPatternList != null && !this.pathPatternList.isEmpty());
    }

    public List<String> getAllDevicePatterns() {
        ArrayList<String> nodes = new ArrayList<String>();
        ArrayList<String> results = new ArrayList<String>();
        this.searchDevicePattern(this.root, nodes, results);
        return results;
    }

    private void searchDevicePattern(PathPatternNode curNode, List<String> nodes, List<String> results) {
        nodes.add(curNode.getName());
        if (curNode.isLeaf()) {
            if (!curNode.getName().equals("**")) {
                results.add(nodes.size() == 1 ? "" : this.convertNodesToString(nodes.subList(0, nodes.size() - 1)));
            } else {
                results.add(this.convertNodesToString(nodes));
            }
            nodes.remove(nodes.size() - 1);
            return;
        }
        if (curNode.isWildcard()) {
            results.add(this.convertNodesToString(nodes));
            nodes.remove(nodes.size() - 1);
            return;
        }
        for (PathPatternNode childNode : curNode.getChildren().values()) {
            this.searchDevicePattern(childNode, nodes, results);
        }
        nodes.remove(nodes.size() - 1);
    }

    public List<PartialPath> getAllPathPatterns() {
        ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        ArrayDeque<String> ancestors = new ArrayDeque<String>();
        this.searchPathPattern(this.root, ancestors, result);
        return result;
    }

    private void searchPathPattern(PathPatternNode node, Deque<String> ancestors, List<PartialPath> fullPaths) {
        if (node.isLeaf()) {
            fullPaths.add(this.convertNodesToPartialPath(node, ancestors));
            return;
        }
        ancestors.push(node.getName());
        for (PathPatternNode child : node.getChildren().values()) {
            this.searchPathPattern(child, ancestors, fullPaths);
        }
        ancestors.pop();
    }

    public List<PartialPath> getOverlappedPathPatterns(PartialPath pattern) {
        if (this.pathPatternList.isEmpty()) {
            this.pathPatternList = this.getAllPathPatterns();
        }
        ArrayList<PartialPath> results = new ArrayList<PartialPath>();
        for (PartialPath path : this.pathPatternList) {
            if (!pattern.overlapWith(path)) continue;
            results.add(path);
        }
        return results;
    }

    private String convertNodesToString(List<String> nodes) {
        StringBuilder fullPathBuilder = new StringBuilder(nodes.get(0));
        for (int i = 1; i < nodes.size(); ++i) {
            fullPathBuilder.append(".").append(nodes.get(i));
        }
        return fullPathBuilder.toString();
    }

    private PartialPath convertNodesToPartialPath(PathPatternNode node, Deque<String> ancestors) {
        Iterator<String> iterator = ancestors.descendingIterator();
        ArrayList<String> nodeList = new ArrayList<String>(ancestors.size() + 1);
        while (iterator.hasNext()) {
            nodeList.add(iterator.next());
        }
        nodeList.add(node.getName());
        return new PartialPath(nodeList.toArray(new String[0]));
    }

    public void serialize(PublicBAOS outputStream) throws IOException {
        this.constructTree();
        this.root.serialize(outputStream);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        this.constructTree();
        this.root.serialize(stream);
    }

    public void serialize(ByteBuffer buffer) {
        this.constructTree();
        this.root.serialize(buffer);
    }

    public static PathPatternTree deserialize(ByteBuffer buffer) {
        PathPatternNode root = PathPatternTree.deserializeNode(buffer);
        PathPatternTree deserializedPatternTree = new PathPatternTree();
        deserializedPatternTree.setRoot(root);
        return deserializedPatternTree;
    }

    private static PathPatternNode deserializeNode(ByteBuffer buffer) {
        PathPatternNode node = new PathPatternNode(ReadWriteIOUtils.readString((ByteBuffer)buffer));
        for (int childrenSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer); childrenSize > 0; --childrenSize) {
            PathPatternNode tmpNode = PathPatternTree.deserializeNode(buffer);
            node.addChild(tmpNode);
        }
        return node;
    }

    public boolean equalWith(PathPatternTree that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return this.getRoot().equalWith(that.getRoot());
    }
}

