/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common.schematree;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.common.schematree.node.SchemaMeasurementNode;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class DeviceSchemaInfo {
    private final PartialPath devicePath;
    private final boolean isAligned;
    private final List<SchemaMeasurementNode> measurementNodeList;

    public DeviceSchemaInfo(PartialPath devicePath, boolean isAligned, List<SchemaMeasurementNode> measurementNodeList) {
        this.devicePath = devicePath;
        this.isAligned = isAligned;
        this.measurementNodeList = measurementNodeList;
    }

    public PartialPath getDevicePath() {
        return this.devicePath;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public List<MeasurementSchema> getMeasurementSchemaList() {
        return this.measurementNodeList.stream().map(measurementNode -> measurementNode == null ? null : measurementNode.getSchema()).collect(Collectors.toList());
    }

    public List<MeasurementPath> getMeasurements(Set<String> measurements) {
        if (measurements.contains("*")) {
            return this.measurementNodeList.stream().map(measurementNode -> {
                if (measurementNode == null) {
                    return null;
                }
                MeasurementPath measurementPath = new MeasurementPath(this.devicePath.concatNode(measurementNode.getName()), (IMeasurementSchema)measurementNode.getSchema());
                if (measurementNode.getAlias() != null) {
                    measurementPath.setMeasurementAlias(measurementNode.getAlias());
                }
                measurementPath.setUnderAlignedEntity(this.isAligned);
                return measurementPath;
            }).collect(Collectors.toList());
        }
        ArrayList<MeasurementPath> measurementPaths = new ArrayList<MeasurementPath>();
        for (SchemaMeasurementNode measurementNode2 : this.measurementNodeList) {
            MeasurementPath measurementPath = new MeasurementPath(this.devicePath.concatNode(measurementNode2.getName()), (IMeasurementSchema)measurementNode2.getSchema());
            measurementPath.setUnderAlignedEntity(this.isAligned);
            if (measurements.contains(measurementNode2.getName())) {
                measurementPaths.add(measurementPath);
                continue;
            }
            if (measurementNode2.getAlias() == null || !measurements.contains(measurementNode2.getAlias())) continue;
            measurementPath.setMeasurementAlias(measurementNode2.getAlias());
            measurementPaths.add(measurementPath);
        }
        return measurementPaths;
    }

    public MeasurementPath getPathByMeasurement(String measurementName) {
        for (SchemaMeasurementNode measurementNode : this.measurementNodeList) {
            MeasurementPath measurementPath = new MeasurementPath(this.devicePath.concatNode(measurementNode.getName()), (IMeasurementSchema)measurementNode.getSchema());
            measurementPath.setUnderAlignedEntity(this.isAligned);
            if (measurementNode.getName().equals(measurementName)) {
                return measurementPath;
            }
            if (measurementNode.getAlias() == null || !measurementNode.getAlias().equals(measurementName)) continue;
            measurementPath.setMeasurementAlias(measurementNode.getAlias());
            return measurementPath;
        }
        throw new SemanticException(String.format("ALIGN BY DEVICE: measurement '%s' does not exist in device '%s'", measurementName, this.getDevicePath()));
    }
}

