/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.rescon;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.service.metrics.MetricsService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricLevel;

public class TimeseriesStatistics {
    private final AtomicLong totalSeriesNumber = new AtomicLong();

    public static TimeseriesStatistics getInstance() {
        return TimeseriesStatisticsHolder.INSTANCE;
    }

    public void init() {
        if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
            MetricsService.getInstance().getMetricManager().getOrCreateAutoGauge(Metric.QUANTITY.toString(), MetricLevel.IMPORTANT, (Object)this.totalSeriesNumber, AtomicLong::get, new String[]{Tag.NAME.toString(), "timeSeries"});
        }
    }

    public long getTotalSeriesNumber() {
        return this.totalSeriesNumber.get();
    }

    public void addTimeseries(int addedNum) {
        this.totalSeriesNumber.addAndGet(addedNum);
    }

    public void deleteTimeseries(int deletedNum) {
        this.totalSeriesNumber.addAndGet(-deletedNum);
    }

    public void clear() {
        this.totalSeriesNumber.getAndSet(0L);
    }

    private static class TimeseriesStatisticsHolder {
        private static final TimeseriesStatistics INSTANCE = new TimeseriesStatistics();

        private TimeseriesStatisticsHolder() {
        }
    }
}

