/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.store.disk.schemafile;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.metadata.schemafile.RecordDuplicatedException;
import org.apache.iotdb.db.exception.metadata.schemafile.SegmentOverflowException;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISegment;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.RecordUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Segment
implements ISegment {
    private static final Logger logger = LoggerFactory.getLogger(Segment.class);
    final ByteBuffer buffer;
    short length;
    short freeAddr;
    short recordNum;
    short pairLength;
    boolean delFlag;
    long prevSegAddress;
    long nextSegAddress;
    List<Pair<String, Short>> keyAddressList;
    List<Pair<String, String>> aliasKeyList;

    public Segment(ByteBuffer buffer, boolean override) {
        this.buffer = buffer;
        if (override) {
            this.length = (short)buffer.capacity();
            this.freeAddr = (short)buffer.capacity();
            this.recordNum = 0;
            this.pairLength = 0;
            this.prevSegAddress = -1L;
            this.nextSegAddress = -1L;
            this.delFlag = false;
            this.keyAddressList = new ArrayList<Pair<String, Short>>();
            this.aliasKeyList = new ArrayList<Pair<String, String>>();
        } else {
            this.length = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
            this.freeAddr = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
            this.recordNum = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
            this.pairLength = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
            this.prevSegAddress = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
            this.nextSegAddress = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
            this.delFlag = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
            buffer.position(25);
            buffer.limit(25 + this.pairLength);
            ByteBuffer pairBuffer = buffer.slice();
            buffer.clear();
            this.reconstructKeyAddress(pairBuffer);
            this.reconstructAliasAddressList();
        }
    }

    public Segment(ByteBuffer buffer) {
        this(buffer, true);
    }

    public Segment(int size) {
        this(ByteBuffer.allocate(size));
    }

    public static ISegment initAsSegment(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return new Segment(buffer, true);
    }

    public static ISegment loadAsSegment(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return new Segment(buffer, false);
    }

    private void reconstructKeyAddress(ByteBuffer pairBuffer) {
        this.keyAddressList = new ArrayList<Pair<String, Short>>();
        for (int idx = 0; idx < this.recordNum; ++idx) {
            String key = ReadWriteIOUtils.readString((ByteBuffer)pairBuffer);
            Short address = ReadWriteIOUtils.readShort((ByteBuffer)pairBuffer);
            this.keyAddressList.add((Pair<String, Short>)new Pair((Object)key, (Object)address));
        }
    }

    private void reconstructAliasAddressList() {
        this.aliasKeyList = new ArrayList<Pair<String, String>>();
        ByteBuffer bufferR = this.buffer.asReadOnlyBuffer();
        bufferR.clear();
        try {
            for (Pair<String, Short> p : this.keyAddressList) {
                String alias;
                if ((Short)p.right < 0) continue;
                bufferR.position(((Short)p.right).shortValue());
                if (RecordUtils.getRecordType(bufferR) != RecordUtils.MEASUREMENT_TYPE || (alias = RecordUtils.getRecordAlias(bufferR)) == null || alias.equals("")) continue;
                this.aliasKeyList.add(this.binaryInsertPairList(this.aliasKeyList, alias), (Pair<String, String>)new Pair((Object)alias, p.left));
            }
        }
        catch (RecordDuplicatedException e) {
            e.printStackTrace();
            logger.error("Record corrupted.");
        }
    }

    @Override
    public int insertRecord(String key, ByteBuffer buf) throws RecordDuplicatedException {
        String alias;
        buf.clear();
        int recordStartAddr = this.freeAddr - buf.capacity();
        int newPairLength = this.pairLength + key.getBytes().length + 4 + 2;
        if (recordStartAddr < 25 + newPairLength) {
            return -1;
        }
        this.pairLength = (short)newPairLength;
        int tarIdx = this.binaryInsertPairList(this.keyAddressList, key);
        if (RecordUtils.getRecordType(buf) == RecordUtils.MEASUREMENT_TYPE && (alias = RecordUtils.getRecordAlias(buf)) != null && !alias.equals("")) {
            this.aliasKeyList.add(this.binaryInsertPairList(this.aliasKeyList, alias), (Pair<String, String>)new Pair((Object)alias, (Object)key));
        }
        buf.clear();
        this.buffer.clear();
        this.buffer.position(recordStartAddr);
        this.buffer.put(buf);
        this.keyAddressList.add(tarIdx, (Pair<String, Short>)new Pair((Object)key, (Object)((short)recordStartAddr)));
        this.freeAddr = (short)recordStartAddr;
        this.recordNum = (short)(this.recordNum + 1);
        return recordStartAddr - this.pairLength - 25;
    }

    @Override
    public IMNode getRecordAsIMNode(String key) throws MetadataException {
        int index = this.getRecordIndexByKey(key);
        if (index < 0) {
            index = this.getRecordIndexByAlias(key);
        }
        if (index < 0) {
            return null;
        }
        ByteBuffer roBuffer = this.buffer.asReadOnlyBuffer();
        short offset = this.getOffsetByKeyIndex(index);
        roBuffer.clear();
        roBuffer.position(offset);
        short len = RecordUtils.getRecordLength(roBuffer);
        roBuffer.limit(offset + len);
        try {
            return RecordUtils.buffer2Node((String)this.keyAddressList.get((int)index).left, roBuffer);
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            logger.error(String.format("Get record[key:%s] failed, start offset:%d, end offset:%d, buffer cap:%d", key, offset, offset + len, roBuffer.capacity()));
            logger.error(String.format("Buffer content: %s", Arrays.toString(Arrays.copyOfRange(roBuffer.array(), (int)offset, Math.min(offset + len, roBuffer.capacity())))));
            logger.error(e.toString());
            throw e;
        }
    }

    @Override
    public boolean hasRecordKey(String key) {
        return this.getRecordIndexByKey(key) > -1;
    }

    @Override
    public boolean hasRecordAlias(String alias) {
        return this.getRecordIndexByAlias(alias) > -1;
    }

    @Override
    public Queue<IMNode> getAllRecords() throws MetadataException {
        ArrayDeque<IMNode> res = new ArrayDeque<IMNode>();
        ByteBuffer roBuffer = this.buffer.asReadOnlyBuffer();
        roBuffer.clear();
        for (Pair<String, Short> p : this.keyAddressList) {
            roBuffer.limit(roBuffer.capacity());
            roBuffer.position(((Short)p.right).shortValue());
            short len = RecordUtils.getRecordLength(roBuffer);
            roBuffer.limit((Short)p.right + len);
            res.add(RecordUtils.buffer2Node((String)p.left, roBuffer));
        }
        return res;
    }

    @Override
    public int updateRecord(String key, ByteBuffer uBuffer) throws SegmentOverflowException, RecordDuplicatedException {
        short newLen;
        short oriLen;
        int idx = this.getRecordIndexByKey(key);
        if (idx < 0) {
            return -1;
        }
        this.buffer.clear();
        uBuffer.clear();
        this.buffer.position(((Short)this.keyAddressList.get((int)idx).right).shortValue());
        String oriAlias = null;
        if (RecordUtils.getRecordType(this.buffer) == RecordUtils.MEASUREMENT_TYPE) {
            oriAlias = RecordUtils.getRecordAlias(this.buffer);
        }
        if ((oriLen = RecordUtils.getRecordLength(this.buffer)) >= (newLen = (short)uBuffer.capacity())) {
            this.buffer.limit(this.buffer.position() + oriLen);
            this.buffer.put(uBuffer);
        } else {
            if (25 + this.pairLength + newLen > this.freeAddr) {
                throw new SegmentOverflowException(idx);
            }
            this.freeAddr = (short)(this.freeAddr - newLen);
            this.buffer.position(this.freeAddr);
            this.buffer.limit(this.freeAddr + newLen);
            this.keyAddressList.get((int)idx).right = this.freeAddr;
            this.buffer.put(uBuffer);
        }
        if (oriAlias != null && !oriAlias.equals("")) {
            this.aliasKeyList.remove(this.binarySearchPairList(this.aliasKeyList, oriAlias));
            uBuffer.clear();
            String alias = RecordUtils.getRecordAlias(uBuffer);
            if (alias != null && !alias.equals("")) {
                this.aliasKeyList.add(this.binaryInsertPairList(this.aliasKeyList, alias), (Pair<String, String>)new Pair((Object)alias, (Object)key));
            }
        }
        return idx;
    }

    @Override
    public int removeRecord(String key) {
        String alias;
        int idx = this.getRecordIndexByKey(key);
        if (idx < 0) {
            return -1;
        }
        this.buffer.clear();
        this.buffer.position(((Short)this.keyAddressList.get((int)idx).right).shortValue());
        if ((Short)this.keyAddressList.get((int)idx).right == this.freeAddr) {
            short len = RecordUtils.getRecordLength(this.buffer);
            this.freeAddr = (short)(this.freeAddr + len);
        }
        if (RecordUtils.getRecordType(this.buffer) == RecordUtils.MEASUREMENT_TYPE && (alias = RecordUtils.getRecordAlias(this.buffer)) != null && !alias.equals("")) {
            this.aliasKeyList.remove(this.binarySearchPairList(this.aliasKeyList, alias));
        }
        this.recordNum = (short)(this.recordNum - 1);
        this.pairLength = (short)(this.pairLength - 2);
        this.pairLength = (short)(this.pairLength - (key.getBytes().length + 4));
        this.keyAddressList.remove(idx);
        return idx;
    }

    @Override
    public void syncBuffer() {
        ByteBuffer prefBuffer = ByteBuffer.allocate(25 + this.pairLength);
        ReadWriteIOUtils.write((short)this.length, (ByteBuffer)prefBuffer);
        ReadWriteIOUtils.write((short)this.freeAddr, (ByteBuffer)prefBuffer);
        ReadWriteIOUtils.write((short)this.recordNum, (ByteBuffer)prefBuffer);
        ReadWriteIOUtils.write((short)this.pairLength, (ByteBuffer)prefBuffer);
        ReadWriteIOUtils.write((long)this.prevSegAddress, (ByteBuffer)prefBuffer);
        ReadWriteIOUtils.write((long)this.nextSegAddress, (ByteBuffer)prefBuffer);
        ReadWriteIOUtils.write((Boolean)this.delFlag, (ByteBuffer)prefBuffer);
        prefBuffer.position(25);
        for (Pair<String, Short> pair : this.keyAddressList) {
            ReadWriteIOUtils.write((String)((String)pair.left), (ByteBuffer)prefBuffer);
            ReadWriteIOUtils.write((short)((Short)pair.right), (ByteBuffer)prefBuffer);
        }
        prefBuffer.clear();
        this.buffer.clear();
        this.buffer.put(prefBuffer);
    }

    @Override
    public void delete() {
        this.delFlag = true;
        this.buffer.clear();
        this.buffer.position(24);
        ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)this.buffer);
    }

    @Override
    public short size() {
        return this.length;
    }

    @Override
    public short getSpareSize() {
        return (short)(this.freeAddr - this.pairLength - 25);
    }

    @Override
    public void extendsTo(ByteBuffer newBuffer) {
        short sizeGap = (short)(newBuffer.capacity() - this.length);
        this.buffer.clear();
        newBuffer.clear();
        if (sizeGap < 0) {
            return;
        }
        if (sizeGap == 0) {
            this.syncBuffer();
            this.buffer.clear();
            newBuffer.put(this.buffer);
            this.buffer.clear();
            newBuffer.clear();
            return;
        }
        ReadWriteIOUtils.write((short)((short)newBuffer.capacity()), (ByteBuffer)newBuffer);
        ReadWriteIOUtils.write((short)((short)(this.freeAddr + sizeGap)), (ByteBuffer)newBuffer);
        ReadWriteIOUtils.write((short)this.recordNum, (ByteBuffer)newBuffer);
        ReadWriteIOUtils.write((short)this.pairLength, (ByteBuffer)newBuffer);
        ReadWriteIOUtils.write((long)this.prevSegAddress, (ByteBuffer)newBuffer);
        ReadWriteIOUtils.write((long)this.nextSegAddress, (ByteBuffer)newBuffer);
        ReadWriteIOUtils.write((Boolean)this.delFlag, (ByteBuffer)newBuffer);
        newBuffer.position(25);
        for (Pair<String, Short> pair : this.keyAddressList) {
            ReadWriteIOUtils.write((String)((String)pair.left), (ByteBuffer)newBuffer);
            ReadWriteIOUtils.write((short)((short)((Short)pair.right + sizeGap)), (ByteBuffer)newBuffer);
        }
        this.buffer.clear();
        this.buffer.position(this.freeAddr);
        this.buffer.limit(this.length);
        newBuffer.position(this.freeAddr + sizeGap);
        newBuffer.put(this.buffer);
        newBuffer.clear();
        this.buffer.clear();
    }

    @Override
    public long getPrevSegAddress() {
        return this.prevSegAddress;
    }

    @Override
    public long getNextSegAddress() {
        return this.nextSegAddress;
    }

    @Override
    public void setPrevSegAddress(long prevSegAddress) {
        this.prevSegAddress = prevSegAddress;
    }

    @Override
    public void setNextSegAddress(long nextSegAddress) {
        this.nextSegAddress = nextSegAddress;
    }

    public ByteBuffer getBufferCopy() {
        this.syncBuffer();
        ByteBuffer newBuffer = ByteBuffer.allocate(this.buffer.capacity());
        this.buffer.clear();
        newBuffer.put(this.buffer);
        newBuffer.clear();
        return newBuffer;
    }

    protected void updateRecordSegAddr(String key, long newSegAddr) {
        int index = this.getRecordIndexByKey(key);
        short offset = this.getOffsetByKeyIndex(index);
        this.buffer.clear();
        this.buffer.position(offset);
        RecordUtils.updateSegAddr(this.buffer, newSegAddr);
    }

    private int getRecordIndexByKey(String key) {
        return this.binarySearchPairList(this.keyAddressList, key);
    }

    private int getRecordIndexByAlias(String alias) {
        int aliasIndex = this.binarySearchPairList(this.aliasKeyList, alias);
        if (aliasIndex < 0) {
            return -1;
        }
        return this.binarySearchPairList(this.keyAddressList, (String)this.aliasKeyList.get((int)aliasIndex).right);
    }

    private short getOffsetByKeyIndex(int index) {
        return (Short)this.keyAddressList.get((int)index).right;
    }

    private <T> int binarySearchPairList(List<Pair<String, T>> list, String key) {
        int head = 0;
        int tail = list.size() - 1;
        if (tail < 0 || key.compareTo((String)list.get((int)head).left) < 0 || key.compareTo((String)list.get((int)tail).left) > 0) {
            return -1;
        }
        if (key.compareTo((String)list.get((int)head).left) == 0) {
            return head;
        }
        if (key.compareTo((String)list.get((int)tail).left) == 0) {
            return tail;
        }
        int pivot = (head + tail) / 2;
        while (key.compareTo((String)list.get((int)pivot).left) != 0) {
            if (head == tail || pivot == head || pivot == tail) {
                return -1;
            }
            if (key.compareTo((String)list.get((int)pivot).left) < 0) {
                tail = pivot;
            } else if (key.compareTo((String)list.get((int)pivot).left) > 0) {
                head = pivot;
            }
            pivot = (head + tail) / 2;
        }
        return pivot;
    }

    private <T> int binaryInsertPairList(List<Pair<String, T>> list, String key) throws RecordDuplicatedException {
        int tarIdx = 0;
        int head = 0;
        int tail = list.size() - 1;
        if (tail == -1) {
            tarIdx = 0;
        } else if (tail == 0) {
            if (((String)list.get((int)0).left).compareTo(key) == 0) {
                throw new RecordDuplicatedException(key);
            }
            tarIdx = ((String)list.get((int)0).left).compareTo(key) > 0 ? 0 : 1;
        } else {
            if (((String)list.get((int)head).left).compareTo(key) == 0 || ((String)list.get((int)tail).left).compareTo(key) == 0) {
                throw new RecordDuplicatedException(key);
            }
            if (((String)list.get((int)head).left).compareTo(key) > 0) {
                tarIdx = 0;
            } else if (((String)list.get((int)tail).left).compareTo(key) < 0) {
                tarIdx = list.size();
            } else {
                while (head != tail) {
                    int pivot = (head + tail) / 2;
                    if (pivot == list.size() - 1) {
                        tarIdx = pivot;
                        break;
                    }
                    if (((String)list.get((int)pivot).left).compareTo(key) == 0 || ((String)list.get((int)(pivot + 1)).left).compareTo(key) == 0) {
                        throw new RecordDuplicatedException(key);
                    }
                    if (((String)list.get((int)pivot).left).compareTo(key) < 0 && ((String)list.get((int)(pivot + 1)).left).compareTo(key) > 0) {
                        tarIdx = pivot + 1;
                        break;
                    }
                    if (pivot == head || pivot == tail) {
                        if (((String)list.get((int)head).left).compareTo(key) > 0) {
                            tarIdx = head;
                        }
                        if (((String)list.get((int)tail).left).compareTo(key) >= 0) break;
                        tarIdx = tail + 1;
                        break;
                    }
                    if (((String)list.get((int)pivot).left).compareTo(key) > 0) {
                        tail = pivot;
                    }
                    if (((String)list.get((int)(pivot + 1)).left).compareTo(key) >= 0) continue;
                    head = pivot;
                }
            }
        }
        return tarIdx;
    }

    @Override
    public String toString() {
        ByteBuffer bufferR = this.buffer.asReadOnlyBuffer();
        StringBuilder builder = new StringBuilder("");
        builder.append(String.format("[size: %d, K-AL size: %d, spare:%d,", this.length, this.keyAddressList.size(), this.freeAddr - this.pairLength - 25));
        bufferR.clear();
        for (Pair<String, Short> pair : this.keyAddressList) {
            bufferR.position(((Short)pair.right).shortValue());
            try {
                if (RecordUtils.getRecordType(bufferR) == 0 || RecordUtils.getRecordType(bufferR) == 1) {
                    builder.append(String.format("(%s -> %s),", pair.left, Long.toHexString(RecordUtils.getRecordSegAddr(bufferR))));
                    continue;
                }
                if (RecordUtils.getRecordType(bufferR) == 4) {
                    builder.append(String.format("(%s, %s),", pair.left, RecordUtils.getRecordAlias(bufferR)));
                    continue;
                }
                logger.error(String.format("Record Broken at: %s", pair));
                throw new BufferUnderflowException();
            }
            catch (BufferOverflowException | BufferUnderflowException e) {
                logger.error(String.format("Segment broken with string: %s", builder.toString()));
                logger.error(String.format("Broken record bytes: %s", Arrays.toString(Arrays.copyOfRange(bufferR.array(), (int)((Short)pair.right).shortValue(), (Short)pair.right + 30))));
                throw e;
            }
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public String inspect() {
        ByteBuffer bufferR = this.buffer.asReadOnlyBuffer();
        StringBuilder builder = new StringBuilder("");
        builder.append(String.format("[length: %d, total_records: %d, spare_size:%d,", this.length, this.keyAddressList.size(), this.freeAddr - this.pairLength - 25));
        bufferR.clear();
        for (Pair<String, Short> pair : this.keyAddressList) {
            bufferR.position(((Short)pair.right).shortValue());
            try {
                if (RecordUtils.getRecordType(bufferR) == 0 || RecordUtils.getRecordType(bufferR) == 1) {
                    builder.append(String.format("(%s, %s, %s),", pair.left, RecordUtils.getAlignment(bufferR) ? "aligned" : "not_aligned", Long.toHexString(RecordUtils.getRecordSegAddr(bufferR))));
                    continue;
                }
                if (RecordUtils.getRecordType(bufferR) == 4) {
                    byte[] schemaBytes = RecordUtils.getSchemaBytes(bufferR);
                    builder.append(String.format("(%s, %s, %s, %s, %s),", pair.left, TSDataType.values()[schemaBytes[0]], TSEncoding.values()[schemaBytes[1]], CompressionType.values()[schemaBytes[2]], RecordUtils.getRecordAlias(bufferR)));
                    continue;
                }
                logger.error(String.format("Record Broken at: %s", pair));
                throw new BufferUnderflowException();
            }
            catch (BufferOverflowException | BufferUnderflowException e) {
                logger.error(String.format("Segment broken with string: %s", builder.toString()));
                logger.error(String.format("Broken record bytes: %s", Arrays.toString(Arrays.copyOfRange(bufferR.array(), (int)((Short)pair.right).shortValue(), (Short)pair.right + 30))));
                throw e;
            }
        }
        builder.append("]");
        return builder.toString();
    }

    static short getSegBufLen(ByteBuffer buffer) {
        short res = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
        buffer.position(buffer.position() - 2);
        return res;
    }

    public ByteBuffer getRecord(String key) {
        int idx = this.getRecordIndexByKey(key);
        if (idx >= 0) {
            short targetAddr = (Short)this.keyAddressList.get((int)idx).right;
            this.buffer.clear();
            this.buffer.position(targetAddr);
            short len = RecordUtils.getRecordLength(this.buffer);
            this.buffer.limit(targetAddr + len);
            return this.buffer.slice();
        }
        return null;
    }

    public ByteBuffer getInnerBuffer() {
        return this.buffer;
    }

    public List<Pair<String, Short>> getKeyOffsetList() {
        return this.keyAddressList;
    }

    private void bufferChecker(ByteBuffer buf) {
        byte type = RecordUtils.getRecordType(buf);
        if (type != 0 && type != 1 && type != 4 || RecordUtils.getRecordLength(buf) <= 0) {
            throw new BufferOverflowException();
        }
        if ((type == 0 || type == 1) && RecordUtils.getRecordLength(buf) != 16) {
            throw new BufferOverflowException();
        }
    }
}

