/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.idtable.entry;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHA256DeviceID
implements IDeviceID {
    long l1;
    long l2;
    long l3;
    long l4;
    private static final String SEPARATOR = "_";
    private static MessageDigest[] md;
    private static final int MD_NUM = 256;
    private static Logger logger;

    public SHA256DeviceID() {
    }

    public SHA256DeviceID(String deviceID) {
        if (deviceID.indexOf(46) == -1) {
            this.fromSHA256String(deviceID);
        } else {
            this.buildSHA256(deviceID);
        }
    }

    private void fromSHA256String(String deviceID) {
        if (deviceID.startsWith("`") && deviceID.endsWith("`")) {
            deviceID = deviceID.substring(1, deviceID.length() - 1);
        }
        String[] part = deviceID.split(SEPARATOR);
        this.l1 = Long.parseLong(part[0]);
        this.l2 = Long.parseLong(part[1]);
        this.l3 = Long.parseLong(part[2]);
        this.l4 = Long.parseLong(part[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildSHA256(String deviceID) {
        byte[] hashVal;
        int slot = this.calculateSlot(deviceID);
        MessageDigest messageDigest = md[slot];
        synchronized (messageDigest) {
            hashVal = md[slot].digest(deviceID.getBytes());
            md[slot].reset();
        }
        this.l1 = this.toLong(hashVal, 0);
        this.l2 = this.toLong(hashVal, 8);
        this.l3 = this.toLong(hashVal, 16);
        this.l4 = this.toLong(hashVal, 24);
    }

    public int hashCode() {
        return (int)this.l1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SHA256DeviceID)) {
            return false;
        }
        SHA256DeviceID that = (SHA256DeviceID)o;
        return this.l1 == that.l1 && this.l2 == that.l2 && this.l3 == that.l3 && this.l4 == that.l4;
    }

    private long toLong(byte[] array, int start) {
        long res = 0L;
        for (int i = 0; i < 8; ++i) {
            res <<= 8;
            res |= (long)array[start + i];
        }
        return res;
    }

    private int calculateSlot(String deviceID) {
        int hashVal = deviceID.hashCode();
        return Math.abs(hashVal == Integer.MIN_VALUE ? 0 : hashVal) % 256;
    }

    public String toString() {
        return "SHA256DeviceID{l1=" + this.l1 + ", l2=" + this.l2 + ", l3=" + this.l3 + ", l4=" + this.l4 + '}';
    }

    @Override
    public String toStringID() {
        return "`" + this.l1 + SEPARATOR + this.l2 + SEPARATOR + this.l3 + SEPARATOR + this.l4 + "`";
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((long)this.l1, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.l2, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.l3, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((long)this.l4, (ByteBuffer)byteBuffer);
    }

    public static SHA256DeviceID deserialize(ByteBuffer byteBuffer) {
        SHA256DeviceID sha256DeviceID = new SHA256DeviceID();
        sha256DeviceID.l1 = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        sha256DeviceID.l2 = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        sha256DeviceID.l3 = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        sha256DeviceID.l4 = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        return sha256DeviceID;
    }

    static {
        logger = LoggerFactory.getLogger(IDTable.class);
        try {
            md = new MessageDigest[256];
            for (int i = 0; i < 256; ++i) {
                SHA256DeviceID.md[i] = MessageDigest.getInstance("SHA-256");
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("can't use sha 256 hash on this platform");
        }
    }
}

