/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.api;

import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.trigger.api.TriggerAttributes;
import org.apache.iotdb.tsfile.utils.Binary;

public interface Trigger {
    default public void onCreate(TriggerAttributes attributes) throws Exception {
    }

    default public void onDrop() throws Exception {
    }

    default public void onStart() throws Exception {
    }

    default public void onStop() throws Exception {
    }

    default public Integer fire(long timestamp, Integer value, PartialPath path) throws Exception {
        return value;
    }

    default public int[] fire(long[] timestamps, int[] values, PartialPath path) throws Exception {
        int size = timestamps.length;
        for (int i = 0; i < size; ++i) {
            this.fire(timestamps[i], values[i], path);
        }
        return values;
    }

    default public Long fire(long timestamp, Long value, PartialPath path) throws Exception {
        return value;
    }

    default public long[] fire(long[] timestamps, long[] values, PartialPath path) throws Exception {
        int size = timestamps.length;
        for (int i = 0; i < size; ++i) {
            this.fire(timestamps[i], values[i], path);
        }
        return values;
    }

    default public Float fire(long timestamp, Float value, PartialPath path) throws Exception {
        return value;
    }

    default public float[] fire(long[] timestamps, float[] values, PartialPath path) throws Exception {
        int size = timestamps.length;
        for (int i = 0; i < size; ++i) {
            this.fire(timestamps[i], Float.valueOf(values[i]), path);
        }
        return values;
    }

    default public Double fire(long timestamp, Double value, PartialPath path) throws Exception {
        return value;
    }

    default public double[] fire(long[] timestamps, double[] values, PartialPath path) throws Exception {
        int size = timestamps.length;
        for (int i = 0; i < size; ++i) {
            this.fire(timestamps[i], values[i], path);
        }
        return values;
    }

    default public Boolean fire(long timestamp, Boolean value, PartialPath path) throws Exception {
        return value;
    }

    default public boolean[] fire(long[] timestamps, boolean[] values, PartialPath path) throws Exception {
        int size = timestamps.length;
        for (int i = 0; i < size; ++i) {
            this.fire(timestamps[i], values[i], path);
        }
        return values;
    }

    default public Binary fire(long timestamp, Binary value, PartialPath path) throws Exception {
        return value;
    }

    default public Binary[] fire(long[] timestamps, Binary[] values, PartialPath path) throws Exception {
        int size = timestamps.length;
        for (int i = 0; i < size; ++i) {
            this.fire(timestamps[i], values[i], path);
        }
        return values;
    }
}

