/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.client;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.BaseClientFactory;
import org.apache.iotdb.commons.client.ClientFactoryProperty;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ClientPoolProperty;
import org.apache.iotdb.commons.client.sync.SyncThriftClient;
import org.apache.iotdb.commons.client.sync.SyncThriftClientWithErrorHandler;
import org.apache.iotdb.commons.consensus.PartitionRegionId;
import org.apache.iotdb.confignode.rpc.thrift.IConfigNodeRPCService;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerReq;
import org.apache.iotdb.confignode.rpc.thrift.TAuthorizerResp;
import org.apache.iotdb.confignode.rpc.thrift.TCheckUserPrivilegesReq;
import org.apache.iotdb.confignode.rpc.thrift.TClusterNodeInfos;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TCountStorageGroupResp;
import org.apache.iotdb.confignode.rpc.thrift.TCreateFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeActiveReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionResp;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteStorageGroupReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteStorageGroupsReq;
import org.apache.iotdb.confignode.rpc.thrift.TDropFunctionReq;
import org.apache.iotdb.confignode.rpc.thrift.TLoginReq;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionReq;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionResp;
import org.apache.iotdb.confignode.rpc.thrift.TSetDataReplicationFactorReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetSchemaReplicationFactorReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetStorageGroupReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.confignode.rpc.thrift.TSetTimePartitionIntervalReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionResp;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchemaResp;
import org.apache.iotdb.db.client.ConfigNodeInfo;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.rpc.RpcTransportFactory;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeClient
implements IConfigNodeRPCService.Iface,
SyncThriftClient,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ConfigNodeClient.class);
    private static final int RETRY_NUM = 5;
    public static final String MSG_RECONNECTION_FAIL = "Fail to connect to any config node. Please check server it";
    private long connectionTimeout = ClientPoolProperty.DefaultProperty.WAIT_CLIENT_TIMEOUT_MS;
    private IConfigNodeRPCService.Iface client;
    private TTransport transport;
    private TEndPoint configLeader;
    private List<TEndPoint> configNodes;
    private TEndPoint configNode;
    private int cursor = 0;
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    ClientManager<PartitionRegionId, ConfigNodeClient> clientManager;
    PartitionRegionId partitionRegionId = ConfigNodeInfo.partitionRegionId;
    TProtocolFactory protocolFactory;

    public ConfigNodeClient() throws TException {
        this.configNodes = ConfigNodeInfo.getInstance().getLatestConfigNodes();
        this.protocolFactory = IoTDBDescriptor.getInstance().getConfig().isRpcThriftCompressionEnable() ? new TCompactProtocol.Factory() : new TBinaryProtocol.Factory();
        this.init();
    }

    public ConfigNodeClient(TProtocolFactory protocolFactory, long connectionTimeout, ClientManager<PartitionRegionId, ConfigNodeClient> clientManager) throws TException {
        this.configNodes = ConfigNodeInfo.getInstance().getLatestConfigNodes();
        this.protocolFactory = protocolFactory;
        this.connectionTimeout = connectionTimeout;
        this.clientManager = clientManager;
        this.init();
    }

    public void init() throws TException {
        this.reconnect();
    }

    public void connect(TEndPoint endpoint) throws TException {
        try {
            this.transport = RpcTransportFactory.INSTANCE.getTransport(endpoint.getIp(), endpoint.getPort(), (int)this.connectionTimeout);
            this.transport.open();
            this.configNode = endpoint;
        }
        catch (TTransportException e) {
            throw new TException((Throwable)e);
        }
        this.client = new IConfigNodeRPCService.Client(this.protocolFactory.getProtocol(this.transport));
    }

    private void reconnect() throws TException {
        try {
            this.tryToConnect();
        }
        catch (TException e) {
            this.syncLatestConfigNodeList();
            this.tryToConnect();
        }
    }

    private void tryToConnect() throws TException {
        if (this.configLeader != null) {
            try {
                this.connect(this.configLeader);
                return;
            }
            catch (TException e) {
                logger.warn("The current node may have been down {},try next node", (Object)this.configLeader);
                this.configLeader = null;
            }
        }
        if (this.transport != null) {
            this.transport.close();
        }
        for (int tryHostNum = 0; tryHostNum < this.configNodes.size(); ++tryHostNum) {
            this.cursor = (this.cursor + 1) % this.configNodes.size();
            TEndPoint tryEndpoint = this.configNodes.get(this.cursor);
            try {
                this.connect(tryEndpoint);
                return;
            }
            catch (TException e) {
                logger.warn("The current node may have been down {},try next node", (Object)tryEndpoint);
                continue;
            }
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TTransport getTransport() {
        return this.transport;
    }

    public void syncLatestConfigNodeList() {
        this.configNodes = ConfigNodeInfo.getInstance().getLatestConfigNodes();
        this.cursor = 0;
    }

    @Override
    public void close() {
        if (this.clientManager != null) {
            this.clientManager.returnClient((Object)this.partitionRegionId, (Object)this);
        } else {
            this.invalidate();
        }
    }

    public void invalidate() {
        this.transport.close();
    }

    public void invalidateAll() {
        this.clientManager.clear((Object)ConfigNodeInfo.partitionRegionId);
    }

    private boolean updateConfigNodeLeader(TSStatus status) {
        if (status.getCode() == TSStatusCode.NEED_REDIRECTION.getStatusCode()) {
            this.configLeader = status.isSetRedirectNode() ? new TEndPoint(status.getRedirectNode().getIp(), status.getRedirectNode().getPort()) : null;
            logger.warn("Failed to connect to ConfigNode {} from DataNode {},because the current node is not leader,try next node", (Object)this.configNode, (Object)this.config.getAddressAndPort());
            return true;
        }
        return false;
    }

    public TDataNodeRegisterResp registerDataNode(TDataNodeRegisterReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TDataNodeRegisterResp resp = this.client.registerDataNode(req);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
                ArrayList<TEndPoint> newConfigNodes = new ArrayList<TEndPoint>();
                for (TConfigNodeLocation configNodeLocation : resp.getConfigNodeList()) {
                    newConfigNodes.add(configNodeLocation.getInternalEndPoint());
                }
                this.configNodes = newConfigNodes;
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus activeDataNode(TDataNodeActiveReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.activeDataNode(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TDataNodeInfoResp getDataNodeInfo(int dataNodeId) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TDataNodeInfoResp resp = this.client.getDataNodeInfo(dataNodeId);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TClusterNodeInfos getAllClusterNodeInfos() throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TClusterNodeInfos resp = this.client.getAllClusterNodeInfos();
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus setStorageGroup(TSetStorageGroupReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.setStorageGroup(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus deleteStorageGroup(TDeleteStorageGroupReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.deleteStorageGroup(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus deleteStorageGroups(TDeleteStorageGroupsReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.deleteStorageGroups(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TCountStorageGroupResp countMatchedStorageGroups(List<String> storageGroupPathPattern) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TCountStorageGroupResp resp = this.client.countMatchedStorageGroups(storageGroupPathPattern);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TStorageGroupSchemaResp getMatchedStorageGroupSchemas(List<String> storageGroupPathPattern) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TStorageGroupSchemaResp resp = this.client.getMatchedStorageGroupSchemas(storageGroupPathPattern);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus setTTL(TSetTTLReq setTTLReq) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.setTTL(setTTLReq);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus setSchemaReplicationFactor(TSetSchemaReplicationFactorReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.setSchemaReplicationFactor(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus setDataReplicationFactor(TSetDataReplicationFactorReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.setDataReplicationFactor(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus setTimePartitionInterval(TSetTimePartitionIntervalReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.setTimePartitionInterval(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSchemaPartitionResp getSchemaPartition(TSchemaPartitionReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSchemaPartitionResp resp = this.client.getSchemaPartition(req);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSchemaPartitionResp getOrCreateSchemaPartition(TSchemaPartitionReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSchemaPartitionResp resp = this.client.getOrCreateSchemaPartition(req);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSchemaNodeManagementResp getSchemaNodeManagementPartition(TSchemaNodeManagementReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSchemaNodeManagementResp resp = this.client.getSchemaNodeManagementPartition(req);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TDataPartitionResp getDataPartition(TDataPartitionReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TDataPartitionResp resp = this.client.getDataPartition(req);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TDataPartitionResp getOrCreateDataPartition(TDataPartitionReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TDataPartitionResp resp = this.client.getOrCreateDataPartition(req);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus operatePermission(TAuthorizerReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.operatePermission(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TAuthorizerResp queryPermission(TAuthorizerReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TAuthorizerResp resp = this.client.queryPermission(req);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TPermissionInfoResp login(TLoginReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TPermissionInfoResp status = this.client.login(req);
                if (!this.updateConfigNodeLeader(status.getStatus())) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TPermissionInfoResp checkUserPrivileges(TCheckUserPrivilegesReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TPermissionInfoResp status = this.client.checkUserPrivileges(req);
                if (!this.updateConfigNodeLeader(status.getStatus())) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TConfigNodeRegisterResp registerConfigNode(TConfigNodeRegisterReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TConfigNodeRegisterResp resp = this.client.registerConfigNode(req);
                if (!this.updateConfigNodeLeader(resp.status)) {
                    return resp;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus addConsensusGroup(TConfigNodeRegisterResp registerResp) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.addConsensusGroup(registerResp);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus removeConfigNode(TConfigNodeLocation configNodeLocation) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.removeConfigNode(configNodeLocation);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus stopConfigNode(TConfigNodeLocation configNodeLocation) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.stopConfigNode(configNodeLocation);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus createFunction(TCreateFunctionReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.createFunction(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus flush(TFlushReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.flush(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TShowRegionResp showRegion(TShowRegionReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TShowRegionResp showRegionResp = this.client.showRegion(req);
                if (!this.updateConfigNodeLeader(showRegionResp.getStatus())) {
                    return showRegionResp;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public long getConfigNodeHeartBeat(long timestamp) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                return this.client.getConfigNodeHeartBeat(timestamp);
            }
            catch (TException e) {
                this.configLeader = null;
                this.reconnect();
                continue;
            }
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public TSStatus dropFunction(TDropFunctionReq req) throws TException {
        for (int i = 0; i < 5; ++i) {
            try {
                TSStatus status = this.client.dropFunction(req);
                if (!this.updateConfigNodeLeader(status)) {
                    return status;
                }
            }
            catch (TException e) {
                this.configLeader = null;
            }
            this.reconnect();
        }
        throw new TException(MSG_RECONNECTION_FAIL);
    }

    public static class Factory
    extends BaseClientFactory<PartitionRegionId, ConfigNodeClient> {
        public Factory(ClientManager<PartitionRegionId, ConfigNodeClient> clientManager, ClientFactoryProperty clientFactoryProperty) {
            super(clientManager, clientFactoryProperty);
        }

        public void destroyObject(PartitionRegionId partitionRegionId, PooledObject<ConfigNodeClient> pooledObject) {
            ((ConfigNodeClient)pooledObject.getObject()).invalidate();
        }

        public PooledObject<ConfigNodeClient> makeObject(PartitionRegionId partitionRegionId) throws Exception {
            Constructor constructor = ConfigNodeClient.class.getConstructor(TProtocolFactory.class, Long.TYPE, this.clientManager.getClass());
            return new DefaultPooledObject((Object)SyncThriftClientWithErrorHandler.newErrorHandler(ConfigNodeClient.class, constructor, (Object[])new Object[]{this.clientFactoryProperty.getProtocolFactory(), this.clientFactoryProperty.getConnectionTimeoutMs(), this.clientManager}));
        }

        public boolean validateObject(PartitionRegionId partitionRegionId, PooledObject<ConfigNodeClient> pooledObject) {
            return pooledObject.getObject() != null && ((ConfigNodeClient)pooledObject.getObject()).getTransport().isOpen();
        }
    }
}

