/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.service;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.udf.service.UDFExecutableManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDFExecutableManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean takeSnapshotForDir(String source, String snapshotDestination) throws IOException {
        SystemFileFactory systemFileFactory = SystemFileFactory.INSTANCE;
        File sourceFile = systemFileFactory.getFile(source);
        File destinationFile = systemFileFactory.getFile(snapshotDestination);
        File temporaryFile = systemFileFactory.getFile(destinationFile.getAbsolutePath() + "-" + UUID.randomUUID());
        if (!sourceFile.exists()) {
            return true;
        }
        FileUtils.deleteQuietly((File)temporaryFile);
        FileUtils.forceMkdir((File)temporaryFile);
        try {
            FileUtils.copyDirectory((File)sourceFile, (File)temporaryFile);
            FileUtils.deleteQuietly((File)destinationFile);
            boolean bl = temporaryFile.renameTo(destinationFile);
            return bl;
        }
        finally {
            FileUtils.deleteQuietly((File)temporaryFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSnapshotForDir(String snapshotSource, String destination) throws IOException {
        SystemFileFactory systemFileFactory = SystemFileFactory.INSTANCE;
        File sourceFile = systemFileFactory.getFile(snapshotSource);
        File destinationFile = systemFileFactory.getFile(destination);
        File temporaryFile = systemFileFactory.getFile(destinationFile.getAbsolutePath() + "-" + UUID.randomUUID());
        if (!sourceFile.exists()) {
            return;
        }
        try {
            if (destinationFile.exists()) {
                FileUtils.deleteQuietly((File)temporaryFile);
                FileUtils.moveDirectory((File)destinationFile, (File)temporaryFile);
            }
            FileUtils.forceMkdir((File)destinationFile);
            try {
                FileUtils.copyDirectory((File)sourceFile, (File)destinationFile);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load udf snapshot and rollback.");
                FileUtils.deleteQuietly((File)destinationFile);
                if (temporaryFile.exists()) {
                    FileUtils.moveDirectory((File)temporaryFile, (File)destinationFile);
                }
            }
        }
        finally {
            FileUtils.deleteQuietly((File)temporaryFile);
        }
    }

    private SnapshotUtils() {
    }
}

