/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.concurrent;

import com.google.common.base.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WrappedRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WrappedRunnable.class);

    @Override
    public final void run() {
        try {
            this.runMayThrow();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw WrappedRunnable.propagate(e);
        }
    }

    public abstract void runMayThrow() throws Exception;

    private static RuntimeException propagate(Throwable throwable) {
        Throwables.throwIfUnchecked((Throwable)throwable);
        throw new RuntimeException(throwable);
    }
}

